
/*
 * dd_ctl.c : This program is the main control program for the DD
 *          : system. It is used in two different ways:
 *          : 1. Directly from DUI. 
 *          : 2. As a server to the standalone dd_ui program.
 *          : Note: the difference between "exit" and "quit" command:
 *          :       exit is used by DUI and removes the DD completely.
 *          :       quit is used by dd_ui and only deattaches from the DD.  
 *
 * Author   :  C.Witzig
 * Date     :  Apr ?, 1992
 *
 * Mods     : May 8, 1995: adapt to new dd_ui in Tcl/Tk
 *                         and include changes with new DD
 */

#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <signal.h>

#include <dd_sys.h>
#include <dd_user.h>
#include <db.h>
/*
static char *dd_states[] = {
  "unused       ",
  "initialised  ",
  "waiting      ",
  "flushing     ", 
  "fucked_up    "
  };
*/
static char *dd_proc_states[] = {
  "unused   ",
  "idle     ",
  "active   ",
  "reqfev   ",
  "putfev   ",
  "brcfev   ",
  "getfev   ",
  "relfev   ",
  "deblocked",
  "exiting  ",
  };

static char *brc_string[] = {
  "OFF      ",
  "SIGNAL   ",
  "USMAIL   "
  };

static char *dd_wait[] = {
  "SLEEP    ",
  "ASYNC    ",
  "UNKNOWN  "
};


void show_sys()
{
  int i,j;
  struct tm ts;

  printf("\n\n\n");
  printf("          *****  DD  SYSTEM  ***** \n");
  printf("                 ----------- \n \n");

  show_dd_dcom();

  printf("              DD MASTERS #%3i  \n",dd_dcom->dd_nmstr);
  printf(" -----------------------------------------\n");
  j = 0;
  for (i=0;i<DD_MAX_NMSTR;i++){
    if ( dd_dcom->dd_master[i].pid > 0 )  {
      printf("  ---> dd_master #%3i ......... : %i \n",++j, 
	     dd_dcom->dd_master[i].pid); 
      printf("       dd_sem, dd_semval        : %6d %6d\n",
	     dd_dcom->dd_master[i].dd_sem, dd_dcom->dd_master[i].dd_semval);
	     
    }
  }
  printf("\n\n");
  

  printf("              DD PROCESSES #%3i \n",dd_dcom->dd_nproc_att);
  printf(" -----------------------------------------\n");
  
  for (i=0;i<DD_MAX_NPROC_ATT;i++){
    if ( dd_dcom->dd_proc[i].pid != -1 ){
      printf("  --->  process pid ........ %i \n", dd_dcom->dd_proc[i].pid);
      printf("        process name ....... %s \n", 
				 dd_dcom->dd_proc[i].pname);
      printf("        process fifo ....... %i \n", 
				 dd_dcom->dd_proc[i].fifo);
      printf("        process status ..... %9s \n", 
				 dd_proc_states[dd_dcom->dd_proc[i].status]);
      printf("        process write/read . %i %i \n", 
	     dd_dcom->dd_proc[i].nputfev,dd_dcom->dd_proc[i].ngetfev);
      printf("        broadcast flag ..... %s \n",
	     brc_string[dd_dcom->dd_proc[i].brc_flag]);
      printf("        broadcast ack  ..... %i \n",
	     dd_dcom->dd_proc[i].brc_ack);
      if ( dd_dcom->dd_proc[i].dd_wait == DD_WAIT_SLEEP ) 
	j = 0;
      else if ( dd_dcom->dd_proc[i].dd_wait == DD_WAIT_ASYNC )
	j = 1;
      else
	j = 2;
      printf("        DD wait mode         %s \n",dd_wait[j]);
      ts = dd_dcom->dd_proc[i].tstart;
      printf("        start time %2i:%2i:%2i  [%2i-%2i-%2i] \n", 
	     ts.tm_hour, ts.tm_min, ts.tm_sec, 
	     ts.tm_mon, ts.tm_mday,ts.tm_year);
      printf("\n");
    }
  }
  printf("\n\n\n");

  return;
}



main()
{
  int i,i1,i2,i3;
  int j,len,*ptr,*p;
  int ikill,pid;
  void show_sys();
  int status,error,got_fev;
  int msec;
  int go_on;
  char what2do[100];
  char what1[100],what2[100],what3[100];
  struct fifo_entry fev;

  printf("\n\n");
  printf(" ********************************************************\n");
  printf(" *                                                      *\n");
  printf(" *         welcome to the  DD  control program          *\n");
  printf(" *                                                      *\n");
  printf(" ********************************************************\n");
  printf("\n\n");

  got_fev = 0;
  go_on = 1;

  while (go_on){
    fflush(stdout);
    if (gets(what2do) == NULL){
      if (errno != EINTR) {
	printf(" dd_ctl: error in gets %s \n",strerror(errno));
	perror(" main: gets");
	go_on = 0;
      }
    }
    else{
      if (strstr(what2do,"att")){
	printf("ddu_attach: status returned %d\n",ddu_attach() );
      }

      else if (strstr(what2do,"cre")){
	if ( dds_create() )
	  printf("dd_ctl: dds_create returns bad status \n");
	else
	  printf("DD system created\n");
      }

      else if (strstr(what2do,"qui") || strstr(what2do,"exit") ){
	go_on = 0;
      }

      else if (strstr(what2do,"hel")){
	printf("\n");
	printf(" type: [commands can be abbreviated to first 3 characters]\n");
	printf(" create .......... to create the dd system \n");
	printf(" flush ........... to flush the dd system  \n");
	printf(" wait ............ to wait until every process is on semaphore\n");
	printf(" help ............ for help \n");
	printf(" exit ............ to exit and remove the dd system \n");
	printf(" fifo_exists fn .. to see whether the fifo fn exists\n");
	printf(" fifo_active fn .. to see whether the fifo is active\n");
	printf(" status .......... to show  \n");
	printf("        proc .....      |-> processes \n");
	printf("        fifo .....      |-> fifo   \n");
	printf("            sem...            |-> semaphores \n");
	printf("            hea...            |-> header(s) \n");
	printf("                                  fifo# or -1 \n");
	printf("            pri...            |-> contents  \n");
	printf("                                  fifo# saddr eaddr \n");
	printf("        dcom .....      |-> dd dcom area \n");
      }
/*
 * the following is a list of special commands, which do not appear on 
 * the normal menu... 
 */
      else if (strstr(what2do,"moreh")){
	printf("\n");
	printf(" MORE HELP \n");
	printf(" Attention: These commands give direct access to DD and \n");
	printf(" ========== should NEVER be used blindly!!! \n");
	printf("                   ***** \n");
	printf("\n");
	printf(" type: [commands can be abbreviated to first 3 characters]\n");
	printf(" fse 'i' 'stat' .. to SEt the status of Fifo #i \n");
	printf(" rmproc 'i' ...... to remove the process with pid = i from the DD \n");
	printf(" fre 'i' ......... to REad an event from Fifo # i \n");
	printf(" fwr 'i' ......... to WRite an event into Fifo # i \n");
	printf(" fdu ............. to DUmp an event previously read with fre(ead) \n");
	printf(" fex 'i1' 'i2' ... to EXchange a fifo event from fifo i1 to i2 \n");
	printf(" ftc 'i1' 'i2' ... to cycle events from fifo #i1 i2 times \n");
	printf(" dbp 'p' 'i1' .... to dump i1 longwords from data buffer starting at *p \n");
      }

      else {
	if ( ! ddu_attached() ) {
	  printf("you must first attach to the DD system\n");
	} else {
     
	  if (strstr(what2do,"flu")){
	    int brc_flush;
	    printf("dd_ctl: flushing system now\n");
	    sscanf(what2do, "%s %d", what1, &brc_flush);

	    if ( dds_flush(brc_flush) ) 
	      printf("dd_ctl: dds_flush returns bad status \n");
	    fflush(stdout);
	  }

	  else if (strstr(what2do,"wak")){
	    if ( dds_wakeup() )
	      printf("dd_ctl: dds_wakeup returns bad status \n");
	  }

	  else if (strstr(what2do,"wait")){
	    sscanf(what2do,"%s %d",what1, &msec);
	    dds_wait4proc(msec);
	  }

	  else if (strstr(what2do,"fifo_exists")){
	    char fname[1024];
	    int status; 
	    sscanf(what2do,"%s %s",what1, fname);
	    status = ddu_fifo_exist(fname);
	    if ( status > 0 )
	      printf("fifo %s exists\n",fname);
	    else
	      printf("fifo %s does not exists\n",fname);
	  }

	  else if (strstr(what2do,"fifo_active")){
	    char fname[1024];
	    int status; 
	    sscanf(what2do,"%s %s",what1, fname);
	    status = ddu_fifo_active(fname);
	    if ( status == 0 )
	      printf("fifo %s active\n",fname);
	    else if ( status > 0 )
	      printf("fifo %s not active\n",fname);
	    else
	      printf("fifo %s does not exists\n", fname);
	  }

	  else if (strstr(what2do,"sta")){
	    i1 = -1; i2 = -1; i3 = -1;
	    sscanf(what2do,"%s %s %s %i %u %u",what1,what2,what3,&i1,&i2,&i3);
	    if (strstr(what2,"pro"))
	      show_sys();
	    if (strstr(what2,"fif")){
	      if ( strstr(what3,"sys")) {
		fifo_print_sys();
	      }
	      if (strstr(what3,"hea")){
		if (i1 == -1){
		  for (i1 = 0;i1<max_fifo_nb;i1++)
		    fifo_print_header(i1);
		}
		else if ( (i1>=0) && (i1<max_fifo_nb) )
		  fifo_print_header(i1);
		else 
		  printf(" bad fifo argument list \n");
	      }
	      else if (strstr(what3,"pri")){
		if ( (i1>=0) && (i1<max_fifo_nb) && (i2>= 0) && (i2<fifo_depth) 
		    && (i3>=0) && (i3<fifo_depth))
		  fifo_print(i1,i2,i3);
		else
		  printf(" fifo print: wrong argument list \n");
	      }
	      else if (strstr(what3,"sem"))
		fifo_sem_status();
	    }
	    else if (strstr(what2,"dco"))
	      show_dd_dcom();
	  }

	  else if (strstr(what2do,"fse")){
	    sscanf(what2do,"%s %i %i",what1,&i1,&i2);
	    if ( (i1>0) && (i1<max_fifo_nb) ){
	      if ( (i2 == FSTAT_IDLE) || (i2 == FSTAT_ACTIVE) )
		fifo_set_status(i1,i2);
	      else
		printf("invalid fifo status %i \n",i2);
	    }
	    else
	      printf("invalid fifo number %i \n",i1);
	  }

	  else if (strstr(what2do,"rmp")){
	    sscanf(what2do,"%s %i",what1,&pid);
	    my_own_ddpid = -1;
	    for (i=0;i<DD_MAX_NPROC_ATT;i++){
	      if (dd_dcom->dd_proc[i].pid == pid){
		my_own_fifo = dd_dcom->dd_proc[i].fifo;
		my_own_ddpid = i;
		printf("deleting process %i at fifo %i as DD proc %i\n",
		       pid,my_own_fifo,my_own_ddpid);
		printf("make sure the process is killed !!!!!\n");
		ddu_stop();
		ddu_close();
	      }
	    }
	    if ( my_own_ddpid == -1 )
	      printf("proc %i not found in DD system\n",pid);
	  }
      
	  else if (strstr(what2do,"fre")){
	    sscanf(what2do,"%s %i",what1,&i1);
	    if ( (i1>=0) && (i1<max_fifo_nb) ){
	      if ( !(status = fifo_read(i1,&fev, -1)) ){
		printf("fifo read %3i - success - event returned \n",i1);
		printf("%10i %6x %10p %6i %6i %6x %6i %6x \n", 
		       fev.shmid,fev.dboff,fev.p2da,fev.len,
		       fev.ctlw1,fev.ctlb1,fev.ctlw2,fev.ctlb2);
		got_fev = 1;
	      }
	      else
		printf("fifo_read: status returned %i \n",status);
	    }
	    else 
	      printf("no such fifo %i",i);
	  }

	  else if (strstr(what2do,"fwr")){
	    sscanf(what2do,"%s %i",what1,&i1);
	    if ( (i1>=0) && (i1<max_fifo_nb) ){
	      if (got_fev){ 
		fifo_write(i1,fev);
		printf("fifo write %3i - success \n",i1);
		got_fev = 0;
	      }
	      else
		printf("have no fev\n");
	    }
	    else 
	      printf("no such fifo %i",i);
	  }

	  else if (strstr(what2do,"fdu")){
	    if (got_fev){
	      printf("%10i %6x %10p %6i %6i %6x %6i %6x \n", 
		     fev.shmid,fev.dboff,fev.p2da,fev.len,
		     fev.ctlw1,fev.ctlb1,fev.ctlw2,fev.ctlb2);
	      if (fev.shmid == -1){
		ptr = db_ptr_shm + fev.dboff;
		for (i=0;i<fev.len;i++){
		  if (i%5 == 0)
		    printf("\n%4i",i);
		  printf("%9x",*ptr++);
		}
	      }
	      else{
		if (db_attmem(fev.shmid,&ptr) < 0)
		  printf("cannot attach volatile buffer!\n");
		else{
		  for (i=0;i<fev.len;i++){
		    if (i%5 == 0)
		      printf("\n%4i");
		    printf("%9x",*ptr++);
		  }
		  if (db_detmem(ptr) < 0)
		    printf("cannot detach volatile buffer \n");
		}
	      }
	    }
	    else
	      printf("have no fev\n");
	    fflush(stdout);
	  }

	  else if (strstr(what2do,"fex")){
	    sscanf(what2do,"%s %i %i %i",what1,&i1,&i2,&i3);
	    printf(" read fifo %4i - write fifo %4i \n",i1,i2);
	    fifo_set_status(i1,FSTAT_ACTIVE);
	    fifo_set_status(i2,FSTAT_ACTIVE);
	    error = 0;
	    i = 0;
	    while ( (!error) && (i++ < i3) )  {
	      if (fifo_read(i1,&fev, -1)){
		printf("error in fifo read %i \n",i1);
		error = 1;
	      }
	      if (fifo_write(i2,fev)){
		printf("error in fifo write %i \n",i2);
		error = 1;
	      }
	      if ( (i%10000) == 0){
		printf("now at event %i \n",i);
		fflush(stdout);
	      }
	    }
	    fifo_set_status(i1,FSTAT_IDLE);
	    fifo_set_status(i2,FSTAT_IDLE);
	    printf("I transferred %i events \n",--i);
	  }

	  else if (strstr(what2do,"ftc")){
	    sscanf(what2do,"%s %i %i",what1,&i1,&i2);
	    printf(" read fifo %4i - write fifo %4i \n",i1,i2);
	    my_own_fifo = i1;
	    fifo_set_status(my_own_fifo,FSTAT_ACTIVE);
	    error = 0;
	    i = 0;
	    while ( (!error) && (i++ < i2) )  {
	      if (i1 == 0){
		len = ((1.1*db_maxevsize)*rand())/32768; 
		if ( ddu_req_fev(len,&fev) != 0){
		  error = 1;
		  printf("ddu_req_fev error");
		  fflush(stdout);
		}
		else{
		  fev.len = len;
		  ptr = fev.p2da;
		  for (j=0;j<len;j++)
		    *ptr++ = len+j;
		}
	      }
	      else{
		if ( ddu_get_fev(&fev) != 0){
		  error = 1;
		  printf("ddu_get_fev error for fifo %3i\n",my_own_fifo);
		}
		else{
		  len = fev.len;
		  ptr = fev.p2da;
		  for (j=0;j<len;j++){
		    if (*ptr++ != (len+j) ){
		      printf("data error for fifo %2i at loc %i %i %i for event \n" 
			     ,i1,j,*ptr,len+j,i);
		      j = len;
		    }
		  }
		}
	      }
	      if (error == 0){
		if ( ddu_put_fev(fev) != 0){
		  error = 1;
		  printf("ddu_put_fev error for fifo %3i\n",my_own_fifo);
		  fflush(stdout);
		}
	      }
	      
	      if ( (i%10000) == 0){
		printf("now at event %i \n",i);
		fflush(stdout);
	      }
	    }
	    fifo_set_status(my_own_fifo,FSTAT_IDLE);
	    printf("I transferred %i events \n",--i);
	  }

	  else if (strstr(what2do,"dbp")){
	    sscanf(what2do,"%s %i %i",what1,&p,&i2);
	    ptr = p;
	    if ( (p<db_ptr_shm) || (p+=i2) > db_shm_end ){
	      printf(" address not in data buffer !! \n");
	      printf(" data buffer boundaries are %p %p \n",db_ptr_shm,db_shm_end);
	    }
	    else{
	      for (i=0;i<i2/5+1;i++){
		printf(" db:%5i %p %9x %9x %9x %9x %9x \n",i,ptr, 
		       *ptr++,*ptr++,*ptr++,*ptr++,*ptr++,*ptr++);
	      }
	    }
	  }
	  
	  /*
	   * ... and finally an undefined command...
	   */
	  else{
	    printf(".... I don't know this command %s \n",what2do);
	  }
	}
      }
    }
  }
  printf("dds_close: status %d\n",dds_close(0));
  
  return;
}
       


