
/*
 * dd_client_test:  Test program for DD client
 * Author        :  C.Witzig
 * Date          :  Jan 2, 1996
 *
 */

/*
 * DD client program:
 * ------------------
 * The DD client connects to a DD server over TCP/IP
 * and sends a simple test string to it.
 *
 * This is the ***TEST*** program, that accesses the network
 * code directly and doesn't use the DD. In the real dd_client 
 * the network code is embedded in the file dd_network.c.
 * 
 * See W.Steven's book "UNIX NETWORK PROGRAMMING" page 284ff
 * for details
 * 
 * The main purpose of this program is to develop, debug and
 * test the DD network connection
 */

/*
 * Mods          :
 *
 */

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <time.h>

#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/times.h>

#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define DD_SERVER_TCP_PORT 6499
#define N_LOOP 50

#include <dd_user.h>


int go_on;
#define TRUE 1
#define FALSE 0

int buffer[1000000];
FILE *fp;

int tmp_buffer[1000000];


static int wrsocket(int fdes, void *p2source, int nbytes, int swap)
{
  int i, *p;
  int status; 
  void *p2data;

  p2data = p2source;

  if ( swap ) {
    int i, *p = tmp_buffer, *p1 = (int*)p2source;

    p2data = (void*)tmp_buffer;
    for (i=0; i++<nbytes/4; p1++) {
      *p = htonl(*p1); 
      p++;
    }
  }

  if ( (status = write(fdes, p2data, nbytes)) < 0){
    sprintf(dd_log_msg,"wrsocket: error in writing to socket - status = %d \n",
	    status, strerror(errno));
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  
  return 0;
}




void send_mtrf()
{
}


main(int argc, char *argv[])
{
  int i;
  int sockfd;
  struct sockaddr_in server_addr;
  struct hostent *p_host;
  struct ddn_cmd ddn_cmd;
  char dd_host[100];

  if ( argc != 2 ) {
    printf("BAD usage: dd_client host_name\n");
    exit(1);
  }
  strcpy(dd_host, argv[1]);

  for (i=0; i<sizeof(buffer)/4; i++)
    buffer[i] = i;

  if ( (p_host = gethostbyname(dd_host)) == NULL ) {
    printf("dd_client: error in gethostbyname: %s \n",strerror(errno));
    exit(1);
  }
 
  bzero( (char*) &server_addr, sizeof(server_addr) );
  server_addr.sin_family = AF_INET;
  bcopy(p_host->h_addr, &(server_addr.sin_addr.s_addr), p_host->h_length);
  server_addr.sin_port = htons(DD_SERVER_TCP_PORT);

  if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0) ) < 0 ) {
    printf("dd_client: error in socket: %s \n",strerror(errno));
    exit(1);
  }

  if ( connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0 ) {
    printf("dd_client: error in connect: %s \n",strerror(errno));
    exit(1);
  }

  go_on = TRUE;
  while ( go_on ) {
    struct tms stime, etime;
    time_t t1, t2;
    int n_iterations, icmd;

    printf("\n enter command : \n ->exit[0] \n ->transfer a string [1] \n ->transfer an integer [2] \n ->transfer a block[3]\n -> block_trf [4] \n");
    scanf("%d", &icmd);
    if ( icmd == 0 ) 
      go_on = FALSE;
    else if ( icmd == 1 ) {
      char a_string[1024];
      printf("\n enter string ");
      scanf("%s",a_string);

      ddn_cmd.header = DDN_HEADER;
      ddn_cmd.cmd = icmd;
      ddn_cmd.len = strlen(a_string)+1;
      if (wrsocket(sockfd, (void*)&ddn_cmd, sizeof(struct ddn_cmd), TRUE ) < 0 ) {
	printf("dd_client: error in write_socket: %s \n",strerror(errno));
	exit(1);
      }
      wrsocket(sockfd, a_string, ddn_cmd.len, FALSE);
    }
    else if ( icmd == 2 ) {
      int an_int;
      printf("\n enter an integer ",&an_int);
      scanf("%d",&an_int);
      ddn_cmd.header = DDN_HEADER;
      ddn_cmd.cmd = icmd;
      ddn_cmd.len = sizeof(icmd);
      if (wrsocket(sockfd, (void*)&ddn_cmd, sizeof(struct ddn_cmd), TRUE ) < 0 ) {
	printf("dd_client: error in write_socket: %s \n",strerror(errno));
	exit(1);
      }
      wrsocket(sockfd, &an_int, ddn_cmd.len, TRUE);
    }
    else if ( icmd == 3 ) {
      int n_iterations;
      printf("enter the number of iterations \n");
      scanf("%d",&n_iterations);
      if ( n_iterations <= 0 ) 
	continue;
      
      times(&stime);
      time(&t1);
      for (i = 0; i < n_iterations; i++ ) {
	ddn_cmd.header =  DDN_HEADER;
	ddn_cmd.cmd = 3;
	ddn_cmd.len = 20;
	if (wrsocket(sockfd, (void*)&ddn_cmd, sizeof(struct ddn_cmd), TRUE ) < 0 ) {
	  printf("dd_client: error in write_socket: %s \n",strerror(errno));
	  exit(1);
	}
	wrsocket(sockfd, buffer, ddn_cmd.len, TRUE);
	if ( i%N_LOOP == 0 ){
	  double delta_t1, delta_t2, n_mby_trf, rate;
	  times(&etime);
	  time(&t2);
	  delta_t1 =  (etime.tms_utime + etime.tms_stime) - (stime.tms_utime + stime.tms_stime);
	  delta_t1 = delta_t1 / ((double)CLK_TCK);
	  delta_t2 = t2 - t1;
	  n_mby_trf = N_LOOP * ddn_cmd.len / (1024.0*1024.0);
	  if ( delta_t2 > 0 ) {
	    rate = n_mby_trf / delta_t2;
	    printf("trf #%d : rate: %6.2f CPU frac: %6.2f delta_t: %6.2f time: %s ", i, rate, (delta_t1/delta_t2), delta_t2, ctime(&t2));
	  }
	  stime = etime;
	  t1 = t2;
	}
      }
    }
    else if ( icmd == 4 ) 
      send_mtrf();
    else 
	printf("\n I don't understand command %d\n",icmd);
  }

  printf("sending exit command now\n");
  ddn_cmd.header = DDN_HEADER;
  ddn_cmd.cmd = DDN_CMD_EXIT;
  ddn_cmd.len = 0;
  wrsocket(sockfd, &ddn_cmd, sizeof(struct ddn_cmd), FALSE);
  close(sockfd);
  exit(0);
}
