
/*
 * dd_client     :  Test program for DD client
 * Author        :  C.Witzig
 * Date          :  Jan 2, 1996
 *
 */

/*
 * DD client program:
 * ------------------
 * The DD client connects to a DD server over TCP/IP
 * and sends a simple test string to it.
 * 
 * See W.Steven's book "UNIX NETWORK PROGRAMMING" page 284ff
 * for details
 * 
 * The main purpose of this program is to develop, debug and
 * test the DD network connection
 */

/*
 * Mods          :
 *
 */

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <time.h>

#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/times.h>

#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define DD_SERVER_TCP_PORT 6499
#define N_LOOP 50

#include <dd_user.h>

extern int readsocket( int fdes, void *p2dest, int nbytes);
extern int writesocket(int fdes, void *p2source, int nbytes, int data_type);

int go_on;
#define TRUE 1
#define FALSE 0

int buffer[1000000];
FILE *fp;
main(int argc, char *argv[])
{
  int i;
  int sockfd;
  struct sockaddr_in server_addr;
  struct hostent *p_host;
  struct ddn_cmd ddn_cmd;
  char dd_host[100];

  if ( argc != 2 ) {
    printf("BAD usage: dd_client host_name\n");
    exit(1);
  }
  strcpy(dd_host, argv[1]);

  for (i=0; i<sizeof(buffer)/4; i++)
    buffer[i] = i;

  if ( (p_host = gethostbyname(dd_host)) == NULL ) {
    printf("dd_client: error in gethostbyname: %s \n",strerror(errno));
    exit(1);
  }
 
  bzero( (char*) &server_addr, sizeof(server_addr) );
  server_addr.sin_family = AF_INET;
  bcopy(p_host->h_addr, &(server_addr.sin_addr.s_addr), p_host->h_length);
  server_addr.sin_port = htons(DD_SERVER_TCP_PORT);

  if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0) ) < 0 ) {
    printf("dd_client: error in socket: %s \n",strerror(errno));
    exit(1);
  }

  if ( connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0 ) {
    printf("dd_client: error in connect: %s \n",strerror(errno));
    exit(1);
  }

  go_on = TRUE;
  while ( go_on ) {
    struct tms stime, etime;
    time_t t1, t2;
    int n_iterations;
    printf("enter the number of iterations \n");
    scanf("%d",&n_iterations);
    if ( n_iterations == 0 ) go_on = FALSE;

    times(&stime);
    time(&t1);
    for (i = 0; i < n_iterations; i++ ) {
      ddn_cmd.header =  DDN_HEADER;
      ddn_cmd.cmd = 0;
      ddn_cmd.len = 250000;
      if (writesocket(sockfd, (void*)&ddn_cmd, sizeof(struct ddn_cmd), DDN_TRF_LONG ) < 0 ) {
	printf("dd_client: error in write_socket: %s \n",strerror(errno));
	exit(1);
      }
      writesocket(sockfd, buffer, ddn_cmd.len, DDN_TRF_LONG);
      if ( i%N_LOOP == 0 ){
	double delta_t1, delta_t2, n_mby_trf, rate;
	times(&etime);
	time(&t2);
	delta_t1 =  (etime.tms_utime + etime.tms_stime) - (stime.tms_utime + stime.tms_stime);
	delta_t1 = delta_t1 / ((double)CLK_TCK);
	delta_t2 = t2 - t1;
	n_mby_trf = N_LOOP * ddn_cmd.len / (1024.0*1024.0);
	rate = n_mby_trf / delta_t2;
	printf("trf #%d : rate: %6.2f CPU frac: %6.2f delta_t: %6.2f time: %s ", i, rate, (delta_t1/delta_t2), delta_t2, ctime(&t2));
	stime = etime;
	t1 = t2;
      }
    }
  }

  printf("sending exit command now\n");
  ddn_cmd.header = DDN_HEADER;
  ddn_cmd.cmd = DDN_CMD_EXIT;
  ddn_cmd.len = 0;
  writesocket(sockfd, &ddn_cmd, sizeof(struct ddn_cmd), DDN_TRF_LONG);
  close(sockfd);
  exit(0);
}
