/*
 * dd_ctl.c : This program is the main control program for the DD
 *          : system. It is used in two different ways:
 *          : 1. Directly from DUI. 
 *          : 2. As a server to the standalone dd_ui program.
 *          : Note: the difference between "exit" and "quit" command:
 *          :       exit is used by DUI and removes the DD completely.
 *          :       quit is used by dd_ui and only deattaches from the DD.  
 *
 * Author   :  C.Witzig
 * Date     :  Apr ?, 1992
 *
 * D.Abbott CEBAF used this as a producer for this performance
 * measurements
 *
 */

#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/times.h>
#include <limits.h>
#include <signal.h>
#include <dd_sys.h>
#include <dd_user.h>

#define TRUE 1
#define FALSE 0

int go_on;

void
sig_handler (int sig)
{
  go_on = 0;
  return;
}

main(int argc,char **argv)
{
  int i,i1,i2,i3, imax;
  int *p;
  int j, jj, len, dump, brc_flag, error;
  long req_fail_count = 0;
  void show_sys();
  int status;
  char what2do[100];
  char what1[100],what2[100],what3[100], answer;
  char fname[100];
  int mode, reqcnt, prescale, wait,ctl[4];
  struct fifo_entry fev;
  time_t stime1, etime1;
  struct tms stime, etime;
  int iprint;
  struct fifo_mode fmode;

  iprint = 110000;

  strcpy(fname,"INPUT");

  fmode.mode = FMODE_ALL;
  fmode.wait = DD_WAIT_ASYNC;
  fmode.prescale = 1;
  fmode.suser = FMODE_MULTI_USER;
  fmode.p2ctl = ctl;

  for (i=0;i<4;i++)
    ctl[i] = -1;

  if ( (status = dds_create()) != 0 ) {
    printf("dds_create: status returned %d\n",status);
    exit(1);
  }

  if ( (status = ddu_init(fname, fmode) ) != 0 ) {
    printf("ddu_init status %d \n",status);
    fflush(stdout);
    exit(1);
  }

  signal (SIGKILL, sig_handler);

  go_on = 1;
  dump = 0;

  system("date");
  while ( go_on && ddu_attached() ) {
    i = 0;
    printf("The number of ddu_req_fev failures is %d\n",req_fail_count);
    printf("enter the number of events\n");
/*
    scanf("%d",&imax);
*/
    imax = 3000000;
    printf("nloops = %d\n",imax);
    if ( imax < 0 )
      go_on = FALSE;
    len = 640;
    i=0;
    req_fail_count = 0;
    time(&stime1);
    times(&stime);
    while ( go_on && (i < imax) ){
      double t,t1, r;

/*    ask for very big events occasionally */
      len = 640;
      if ( (i%100) == 0 )
	len = 100000;
      
      status = ddu_req_fev(len, &fev);
      if (status == 0){
	p = fev.p2da;
	fev.len = len;
	fev.ctlw1 = i%4+1;
	fev.ctlb1 = rand()&3; 
	fev.ctlw2 = -1;
	fev.ctlb2 = -1;
	
	fev.p2da[0] = 0x12345678;
	
	if ( ( status = ddu_put_fev(fev) ) != 0){
	  printf("ddu_put_fev: status returned %d \n",status);		  
	  go_on = FALSE;
	}
	i++;
	if ((i % iprint) == 0) {
	  time(&etime1);	
	  t1 = etime1 - stime1;
	  stime1 = etime1;
	  times(&etime);
	  t = (etime.tms_utime + etime.tms_stime) - (stime.tms_utime + stime.tms_stime);
	  r = 100.0 * (etime.tms_utime - stime.tms_utime) / t;
	  t = t / ((double)CLK_TCK);
	  printf("event %d: fail count: %d time:%6.2f Sec - CPU user/tot %6.1f rate1 %6.1f ev/sec  rate2 %6.1f \n",
		 i,req_fail_count,t,r,iprint/t,iprint/t1);
	  stime = etime;
 
	  /*
	     t = (etime.time - stime.time) + (etime.millitm - stime.millitm)/1000.0;
	     r = ((fev.len) * 4.0 * 10000.0)/t;
	     printf("event %8d  %f Sec/10000 %f kB/S\n",i,t,r);
	     bcopy(&etime,&stime,sizeof(struct timeb));
	     */
	}
      } else if ( status > 0 ) {
	req_fail_count++;
      }
      else {
	go_on = FALSE;
      }
    }
    go_on = FALSE;
  }
  system("date");
  ddu_close();
  printf("dd cleaned up\n");
  return;
}
       
