/* This file has been generated from the following Tcl source file(s): ROC_class.tcl
 * on Mon Feb  2 10:52:05 EST 2004 by abbottd
 */
#include <tcl.h>
static char initCmd[] = 
    "if {\"[info command ROC]\"!=\"ROC\"} {\n"
    "    global tcl_modules\n"
    "    \n"
    "    lappend tcl_modules \"ROC_class.tcl {} {} {\\$Id: ROC_class.tcl,v 1.38 2002/10/21 14:51:29 abbottd Exp $}\"\n"
    "    \n"
    "    class ROC {\n"
    "	inherit CODA\n"
    "	\n"
    "	method   download       {config} @roc_download\n"
    "	method   prestart       {}       @roc_prestart\n"
    "	method   go             {}       @roc_go\n"
    "	method   end            {}       @roc_end\n"
    "	method   pause          {}       @roc_pause\n"
    "	\n"
    "	method   exit           {}       {}\n"
    "	\n"
    "	method   check_bb       {}       @check_bb\n"
    "\n"
    "	method   roc_dump       {}       @roc_dump\n"
    "	method   roc_cleanup    {}       @roc_cleanup\n"
    "	\n"
    "	method   part_stats     {p}      @partStats_cmd\n"
    "	method   part_stats_all {}       @partStatsAll_cmd\n"
    "	method   part_reinit_all {}      @partReInitAll_cmd\n"
    "	\n"
    "	method   token_handler  {name limit id}       @roc_token_handler\n"
    "	\n"
    "	method   test_event     {}       @roc_test_event\n"
    "	method   test_link      {nBuffers}            @roc_test_link\n"
    "\n"
    "	method   open_links     {}       {}\n"
    "	method   close_links    {}       {}\n"
    "	\n"
    "	method   rol0           {}       {}\n"
    "	method   rol1           {}       {}\n"
    "	method   token_debug    {}       @token_debug\n"
    "	method   roc_constructor           {args} @roc_constructor\n"
    "	method udp_RPC_handler {s f} {}\n"
    "\n"
    "	constructor      {sess} {CODA::constructor $sess} {\n"
    "	    global env\n"
    "	    roc_constructor $sess\n"
    "	    set session $sess\n"
    "	    \n"
    "	    if { ![catch \"set env(TOKEN_PORT)\" res] } {\n"
    "		set udp_port [dp_connect -udp $env(TOKEN_PORT)]\n"
    "		dp_filehandler [lindex $udp_port 0] r \"itcl_context $this ::ROC udp_RPC_handler\"\n"
    "	    }\n"
    "	    set output_file \"\"\n"
    "	    set output_type \"\"\n"
    "	    set current_file \"\"\n"
    "	}\n"
    "	\n"
    "	destructor                      @roc_destructor\n"
    "	\n"
    "	public variable bigendian_out 1\n"
    "	public variable rols    {}\n"
    "	public variable config  \"\"\n"
    "	public variable runtype \"\"\n"
    "	public variable inputs  \"\"\n"
    "	public variable outputs \"\"\n"
    "	public variable next    \"\"\n"
    "	public variable output_type\n"
    "	public variable output_file\n"
    "	public variable current_file\n"
    "	private variable links \"\"\n"
    "	public variable session\n"
    "	public variable prime \"\"\n"
    "	public variable token_interval @token_interval\n"
    "	public variable got_next_roc @got_next_roc\n"
    "	public variable async_roc 0\n"
    "	public variable first\n"
    "	public variable randy_factor 32\n"
    "    }\n"
    "    \n"
    "    body ROC::udp_RPC_handler {s f} {\n"
    "	set message [dp_receiveFrom $f 1024 -noaddr]\n"
    "	catch $message res\n"
    "    }\n"
    "\n"
    "    body ROC::open_links {} {\n"
    "	\n"
    "	database query \"select name,inputs,outputs,next,first from $config where name='$name'\"\n"
    "	\n"
    "	set res [database get next]\n"
    "	set inputs  [lindex $res 1]\n"
    "	set outputs [lindex $res 2]\n"
    "	set next    [lindex $res 3]\n"
    "	set first   [lindex $res 4] \n"
    "	if { \"$next\" != \"\" } {\n"
    "	    set got_next_roc 1\n"
    "	    puts \"next ROC in token chain is $next\"\n"
    "	} else {\n"
    "	    set got_next_roc 0\n"
    "	    puts \"no next ROC in token chain\"\n"
    "	}\n"
    "	dalogmsg \"INFO\" \"opening datalink to $outputs\"\n"
    "\n"
    "	if {\"$outputs\" != \"\"} {\n"
    "	    case [lindex $outputs 0] {\n"
    "		file* {\n"
    "		    set output_type [lindex $outputs 0]\n"
    "		    database query \"select value from [set config]_option where name='dataFile'\"\n"
    "		    set output_file [database get next]\n"
    "		    if { \"$output_file\" == \"\" } {\n"
    "			database query \"select code from [set config] where name='$output_type'\"\n"
    "			set a [database get next]\n"
    "			set a [lindex $a 0]\n"
    "			set output_file [lindex $a 0]\n"
    "		    } \n"
    "		    if { \"$output_file\" == \"\" } {\n"
    "			set output_file \"test.dat\"\n"
    "		    }\n"
    "		    puts \"binary format file $output_file\"\n"
    "		}\n"
    "		dd* {\n"
    "		    set output_type [lindex $outputs 0]\n"
    "	        }\n"
    "		coda* {\n"
    "		    set output_type [lindex $outputs 0]\n"
    "		    database query \"select value from [set config]_option where name='dataFile'\"\n"
    "		    set output_file [database get next]\n"
    "		    if { \"$output_file\" == \"\" } {\n"
    "			database query \"select code from [set config] where name='$output_type'\"\n"
    "			\n"
    "			set a [database get next]\n"
    "			set a [lindex $a 0]\n"
    "			set output_file [lindex $a 0]\n"
    "		    }\n"
    "		    if { \"$output_file\" == \"\" } {\n"
    "			set output_file \"test.dat\"\n"
    "		    }\n"
    "		    puts \"CODA format file $output_file\"\n"
    "		}\n"
    "		debug* {\n"
    "		    set async_roc 0\n"
    "		    set output_type [lindex $outputs 0]\n"
    "		}\n"
    "		none* {\n"
    "		    set async_roc 0\n"
    "		    set output_type [lindex $outputs 0]\n"
    "		}\n"
    "		default {\n"
    "		    foreach link $outputs {\n"
    "			set res [split $link :]\n"
    "			if { [llength $res] == 1 } {\n"
    "			    LINK $link $session $name $link out\n"
    "			} else {\n"
    "			    LINK [lindex $res 0] $session $name [lindex $res 0] out\n"
    "			}\n"
    "			lappend links [lindex $res 0]\n"
    "			database query \"select first from $config where name='[lindex $res 0]'\"\n"
    "			set res2 [database get next]\n"
    "			if { \"$res2\" == \"yes\" } {\n"
    "			    set prime [lindex $res 0]\n"
    "			}\n"
    "		    }\n"
    "		    set async_roc 0\n"
    "		    set output_type network\n"
    "		    puts \"prime is $prime next is $next\"\n"
    "		    \n"
    "		    return\n"
    "		}\n"
    "	    }\n"
    "	} else {\n"
    "	    puts \"No output type specified - set to none\"\n"
    "	    if { \"$output_type\" == \"network\" } {\n"
    "		set output_type none\n"
    "	    }\n"
    "            set output_type none\n"
    "	}\n"
    "	set links \"\"\n"
    "	set prime \"\"\n"
    "	set next \"\"\n"
    "    }    \n"
    "    \n"
    "    body ROC::close_links {} {\n"
    "	foreach link $links {\n"
    "	    catch \"delete object $link\"\n"
    "	}\n"
    "	set links \"\"\n"
    "    }\n"
    "    \n"
    "    body ROC::exit {} {\n"
    "	global os_name\n"
    "	\n"
    "	set async_roc 1\n"
    "	end\n"
    "	close_links\n"
    "	roc_cleanup\n"
    "	set state configured\n"
    "    }\n"
    "    \n"
    "    proc every {time args} {\n"
    "	eval  $args\n"
    "	dp_after $time every $time $args\n"
    "    }\n"
    "    \n"
    "    proc poll {} {}\n"
    "\n"
    "    proc ftest {} {\n"
    "	ROC2 download rocalone\n"
    "	ROC2 prestart\n"
    "    }\n"
    "\n"
    "    proc fgen {runnb runty config} {\n"
    "	puts \"filename for run $runnb type $runty config $config\"\n"
    "	return test.data\n"
    "    }\n"
    "\n"
    "    proc test_start {} {\n"
    "	global fd\n"
    "	set fd [open \"stats.dat\" w]\n"
    "	ev_size\n"
    "    }\n"
    "\n"
    "    proc ev_size {} {\n"
    "	global fd\n"
    "	set stats [ROC2 statistics]\n"
    "	set size [ROC2 cget -user_flag3]\n"
    "\n"
    "	puts $fd \"$size [lindex $stats 1] [lindex $stats 3]\"\n"
    "	puts  \"$size [lindex $stats 1] [lindex $stats 3]\"\n"
    "\n"
    "	set size [expr $size + 100]\n"
    "\n"
    "	ROC2 configure -user_flag3 $size\n"
    "\n"
    "	dp_after 5000 ev_size\n"
    "    }\n"
    "}\n"
    "\n"
    "\n"
    ;
/* End of Tcl code */
/* Init routine to drag this code into our program...*/
int ROC_class_Init (Tcl_Interp *interp)
{
    if (Tcl_Eval(interp,initCmd) != 0) {
    char *val;
    fprintf (stderr, "ERROR:\\n      %s\\n", interp->result);
    val = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
    fprintf (stderr, "TclStack:\\n      %s\\n",val);
       return TCL_ERROR;
    }
    return TCL_OK;
}
/* End of C code */
