/* This file has been generated from the following Tcl source file(s): ER_class.tcl
 * on Mon Feb  2 10:52:15 EST 2004 by abbottd
 */
#include <tcl.h>
static char initCmd[] = 
    "if {\"[info command ER]\"!=\"ER\"} {\n"
    "global tcl_modules\n"
    "\n"
    "lappend tcl_modules \"ER_class.tcl {} {} {\\$Id: ER_class.tcl,v 2.18 2000/01/14 21:50:40 abbottd Exp $}\"\n"
    "class ER {\n"
    "    inherit CODA\n"
    "    \n"
    "    method   download       {conf}   {} \n"
    "    method   download_c     {conf}   @ER_download_c \n"
    "    method   prestart       {}       {}\n"
    "    method   prestart_c     {}       @ER_prestart\n"
    "    method   go             {}       {}\n"
    "    method   end            {}       {}\n"
    "    method   pause          {}       {}\n"
    "    \n"
    "    method   daq            {arg}    @ER_daq_cmd\n"
    "    method   conf           {}       {}\n"
    "    method   flush           {}      @ER_flush_dd\n"
    "\n"
    "    constructor      {sess} {CODA::constructor $sess} @log_constructor\n"
    "    \n"
    "    destructor                      {}\n"
    "    \n"
    "    public  variable config  \"\"\n"
    "    private variable session\n"
    "\n"
    "    public  variable flushinterval \"1000\"\n"
    "    public  variable SPLITMB \"2047\"\n"
    "    public  variable RECL    \"32678\"\n"
    "    public  variable bgid \"\"\n"
    "    public  variable EvDumpLevel \"0\"\n"
    "\n"
    "    public variable outputs \"\"\n"
    "    public variable output_type\n"
    "    public variable output_switch\n"
    "    public variable output_file \"test.dat\"\n"
    "    public variable filename \"\"\n"
    "    public variable current_file \"\"\n"
    "    public variable file_events 0\n"
    "    public variable file_nlongs 0\n"
    "    public variable file_nerrors 0\n"
    "\n"
    "    public variable nEnd 1\n"
    "}\n"
    "\n"
    "struct_typedef fev {struct\n"
    "    {int shmid}\n"
    "    {int dboff}\n"
    "    {int p2da}\n"
    "    {int len}\n"
    "    {int ctlw1}\n"
    "    {int ctlb1}\n"
    "    {int ctlw2}\n"
    "    {int ctlb2}\n"
    "}\n"
    "\n"
    "struct_typedef ev_buf {struct\n"
    "    {ulong len}\n"
    "    {ulong*0 data}\n"
    "}\n"
    "\n"
    "body ER::download {conf} {\n"
    "    puts \"ER::download $conf called\"\n"
    "    set config $conf\n"
    "    dalogmsg INFO \"download\"\n"
    "    set RECL 32768\n"
    "    conf\n"
    "    download_c $conf\n"
    "\n"
    "    dalogmsg INFO \"downloaded\"\n"
    "    $this status downloaded\n"
    "}\n"
    "\n"
    "body ER::prestart {} {\n"
    "    puts \"ER::prestart called\"\n"
    "    dalogmsg INFO \"prestarting\"\n"
    "    flush\n"
    "    set nEnd 1\n"
    "    prestart_c\n"
    "\n"
    "    puts \"output_switch = $output_switch\"\n"
    "    case $output_switch {\n"
    "     2  {\n"
    "	daq debug\n"
    "	dalogmsg WARN \"Output to debug\"\n"
    "     }\n"
    "     3  {\n"
    "	daq none\n"
    "	dalogmsg WARN \"Output to none\"\n"
    "     }\n"
    "     default  {\n"
    "        daq open\n"
    "        dalogmsg INFO \"Output to file '$current_file' for writing\"\n"
    "        }\n"
    "    }\n"
    "    $this status paused\n"
    "}\n"
    "\n"
    "body ER::go {} {\n"
    "    puts \"ER::go called\"\n"
    "    dalogmsg INFO \"activating\"\n"
    "    daq resume\n"
    "    dalogmsg INFO \"activated\"\n"
    "    $this status active\n"
    "}\n"
    "\n"
    "body ER::pause {} {\n"
    "    puts \"ER::pause called\"\n"
    "    daq pause\n"
    "    $this status paused\n"
    "}\n"
    "\n"
    "body ER::end {} {\n"
    "    puts \"ER::end called\"\n"
    "    dalogmsg INFO \"ending\"\n"
    "    daq close\n"
    "    $this status downloaded\n"
    "    dalogmsg INFO \"ended\"\n"
    "}\n"
    "\n"
    "body ER::conf {} {\n"
    "\n"
    "    database query \"select name,value from ${config}_option where name='flushinterval'\"\n"
    "    set res [database get next]\n"
    "    if { \"$res\" != \"\"} {\n"
    "	set flushinterval [lindex $res 1]\n"
    "    }\n"
    "    database query \"select name,value from ${config}_option where name='SPLITMB'\"\n"
    "    set res [database get next]\n"
    "    if { \"$res\" != \"\"} {\n"
    "	puts \"SPLITMB was $SPLITMB\"\n"
    "	set SPLITMB [expr [lindex $res 1] << 20 ]\n"
    "	puts \"SPLITMB is $SPLITMB\"\n"
    "    } else {\n"
    "	set SPLITMB 0\n"
    "    }\n"
    "    database query \"select name,value from ${config}_option where name='RECL'\"\n"
    "    set res [database get next]\n"
    "\n"
    "    if { \"$res\" != \"\"} {\n"
    "	set RECL [lindex $res 1]\n"
    "	puts \"RECL was $RECL\"\n"
    "    } else {\n"
    "	set RECL 32768\n"
    "    }\n"
    "\n"
    "    database query \"select name,value from ${config}_option where name='EvDumpLevel'\"\n"
    "    set res [database get next]\n"
    "    if { \"$res\" != \"\"} {\n"
    "	set EvDumpLevel [lindex $res 1]\n"
    "    }\n"
    "    database query \"select name,inputs,outputs from $config where name='$name'\"\n"
    "    set res [database get next]\n"
    "\n"
    "    set inputs \"\"\n"
    "    set output_type \"coda\"\n"
    "\n"
    "    if { \"$res\" != \"\"} {\n"
    "	set inputs  [lindex $res 1]\n"
    "	set outputs [lindex $res 2]\n"
    "	set output_type [lindex $outputs 0]\n"
    "    } \n"
    "\n"
    "    set output_switch 3\n"
    "\n"
    "    puts -nonewline \"$name will output to \"\n"
    "\n"
    "    case $output_type {\n"
    "	file* {\n"
    "	    \n"
    "	    database query \"select value from [set config]_option where name='dataFile'\"\n"
    "	    \n"
    "	    set output_file [database get next]\n"
    "	    if { \"$output_file\" == \"\" } {\n"
    "		database query \"select code from [set config] where name='$output_type'\n"
    "		set a [database get next]\n"
    "		set a [lindex $a 0]\n"
    "		set output_file [lindex $a 0]\n"
    "\n"
    "                if { \"[lindex $a 0]\" == \"CODA\" } {\n"
    "   	          puts \"coda format file $output_file\"\n"
    "	          set output_switch 4\n"
    "                }\n"
    "	        if { \"[lindex $a 0]\" == \"BINA\" } {\n"
    "   	          puts \"binary format file $output_file\"\n"
    "	          set output_switch 1\n"
    "                }\n"
    "	    } else {\n"
    "	      set output_switch 1\n"
    "	      puts \"binary file  $output_file\"\n"
    "            }\n"
    "	    if { \"$output_file\" == \"\" } {\n"
    "		set output_file \"test.dat\"\n"
    "	    }\n"
    "	}\n"
    "	debug* {\n"
    "	    puts \"debug dump\"\n"
    "	    set output_switch 2\n"
    "	}\n"
    "	none* {\n"
    "	    puts \"/dev/null\"\n"
    "	    set output_switch 3\n"
    "	}\n"
    "	coda* {\n"
    "	    database query \"select value from [set config]_option where name='dataFile'\"\n"
    "	    set output_file [database get next]\n"
    "	    if { \"$output_file\" == \"\" } {\n"
    "		database query \"select code from [set config] where name='$output_type'\n"
    "\n"
    "		set a [database get next]\n"
    "		set a [lindex $a 0]\n"
    "		set output_file [lindex $a 0]\n"
    "	        if { \"[lindex $a 0]\" == \"CODA\" } {\n"
    "   	          puts \"coda format file $output_file\"\n"
    "	          set output_switch 4\n"
    "                }\n"
    "	        if { \"[lindex $a 0]\" == \"BINA\" } {\n"
    "   	          puts \"binary format file $output_file\"\n"
    "	          set output_switch 1\n"
    "                }\n"
    "	    } else {\n"
    "  	      puts \"coda format file $output_file\"\n"
    "	      set output_switch 4\n"
    "            }\n"
    "	    if { \"$output_file\" == \"\" } {\n"
    "		set output_file \"test.dat\"\n"
    "	    }\n"
    "	}\n"
    "	default {\n"
    "	    puts \"invalid output type $output_type\"\n"
    "	}\n"
    "    }\n"
    "    if {\"$output_file\" == \"\" } {\n"
    "       set output_file \"test.dat\"\n"
    "    } \n"
    "    puts \"\"\n"
    "}    \n"
    "}\n"
    ;
/* End of Tcl code */
/* Init routine to drag this code into our program...*/
int ER_class_Init (Tcl_Interp *interp)
{
    if (Tcl_Eval(interp,initCmd) != 0) {
    char *val;
    fprintf (stderr, "ERROR:\\n      %s\\n", interp->result);
    val = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
    fprintf (stderr, "TclStack:\\n      %s\\n",val);
       return TCL_ERROR;
    }
    return TCL_OK;
}
/* End of C code */
