#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

set PWD [pwd]

foreach dir $argv {
    cd $dir

    foreach filename [glob -nocomplain *] {
	case [file ext $filename] {
	    {".xbm" ""} {

		set root [file root $filename]
		if {$root == ""} {
		    continue
		}

		puts "\{"
		puts [exec cat $filename]
		puts -nonewline "Tk_DefineBitmap(Et_Interp, "
		puts -nonewline "Tk_GetUid(\"$root\"), "
		puts -nonewline "$root\_bits, "
		puts -nonewline "$root\_width, "
		puts -nonewline "$root\_height);"
		puts ""
		puts "\}"

	    }
	    {.xpm} {
		set name [file root $filename]
		set root [file root $filename]\_xpm
		puts "\{"
		puts [exec cat $filename]
		puts -nonewline "Tix_DefinePixmap(Et_Interp, "
		puts -nonewline "Tk_GetUid(\"$name\"), "
		puts -nonewline "$root);"
		puts ""
		puts "\}"
	    }
	}
    }
    cd $PWD
}

