proc About {} {
    return "Testing the event emulation routines in the test suite"
}

proc Test {} {
    global foo
    set foo 0

    # Clicking a button
    #
    button .b -command "set foo 1"
    pack .b; update

    Click .b

    Assert {$foo == 1}

    # Selecting a listbox
    #
    tixHList .l
    pack .l; update
    .l add 1 -text Hi
    .l add 2 -text Hi
    .l add 3 -text Hi
    .l add 4 -text Hi
    .l add 5 -text Hi

    Click .l 5 5
    Assert {[.l info selection] == "1"}

    # Drag and selecting a combobox
    #
    tixComboBox .c
    .c insert end 10
    .c insert end 10
    .c insert end 10
    .c insert end 10
    .c insert end 10
    pack .c; update

    HoldDown [.c subwidget arrow]
    Drag [.c subwidget listbox] 10 10
    Release [.c subwidget listbox] 10 10
    Release [.c subwidget arrow] -30 30

    Assert {[.c cget -value] == "10"}


    # Double-clicking
    #
    tixDirList .d
    pack .d

    Double [.d subwidget hlist] 5 5
    Assert {[.d cget -value] == "/"}
}


## MAIN_BEGIN

source ../library/TestLib.tcl
Test
Done

## MAIN_END
