/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      This window display time and other misc information
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: MiscPanel.java,v $
 *   Revision 1.2  2001/10/19 18:16:12  chen
 *   Change how image is loaded
 *
 *   Revision 1.1  2001/10/18 18:45:42  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.util.*;
import java.text.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

import cmlog.*;

public class MiscPanel implements ActionListener
{
    /**
     * Internal JPanel holding varioud components.
     */
    private JPanel panel_;

    /**
     * Current time display.
     */
    private JTextField currentTime_;

    /**
     * Starting time display.
     */
    private JTextField startTime_;

    /**
     * End time display.
     */
    private JTextField endTime_;

    /**
     * Empty String.
     */
    private static final String istr_ = "Mon Oct 8 01:51:20 2001";

    /**
     * Formatter for a Date object.
     */
    private SimpleDateFormat formatter_;

    /**
     * Date Format string.
     */
    private static final String formatString_ = "EEE MMM d hh:mm:ss yyyy";

    /**
     * Number of column for text field
     */
    private static final int    numc_ = 16;

    /**
     * Stop button to stop a query process.
     */
    private JButton stop_ = null;

    /**
     * Display reference
     */
    private Disp disp_ = null;

    
    /**
     * Constructor.
     */
    public MiscPanel (Disp disp)
    {
	disp_ = disp;

	// create own font
	Font lfont = new Font("Helvetica", Font.PLAIN, 12);

	// create formatter
	formatter_ = new SimpleDateFormat (formatString_);

	// create a panel 
	panel_ = new JPanel (new BorderLayout ());

	// create a subpanel holding current time
	JPanel leftpanel = new JPanel ();
	panel_.add (leftpanel, BorderLayout.WEST);

	// create stop button
	ImageIcon icon = null;
	byte[] img = Util.imageByte (Util.stopbytes);
	if (img != null)
	    icon = new ImageIcon(img);	    
	stop_ = new JButton (icon);
	stop_.setVisible (false);
	stop_.setBorder (null);
	stop_.addActionListener (this);
	panel_.add (stop_, BorderLayout.CENTER);

	// create a subpanel holding start and end time
	JPanel rightpanel = new JPanel ();
	panel_.add (rightpanel, BorderLayout.EAST);

	// create current time
	currentTime_ = new JTextField (numc_);
	currentTime_.setFont(lfont);	
	currentTime_.setEditable (false);
	currentTime_.setHorizontalAlignment (JTextField.CENTER);
	leftpanel.add (currentTime_);

	// create start time
	// get prefered label size
	JLabel lstart = new JLabel ("From ");
	rightpanel.add (lstart);

	startTime_ = new JTextField (numc_) ;
	startTime_.setFont(lfont);
	startTime_.setEditable (false);	
	startTime_.setHorizontalAlignment (JTextField.CENTER);
	rightpanel.add (startTime_);

	// create end time
	JLabel lend = new JLabel ("End ");
	rightpanel.add (lend);

	endTime_ = new JTextField (numc_);
	endTime_.setFont(lfont);
	endTime_.setEditable (false);
	endTime_.setHorizontalAlignment (JTextField.CENTER);
	rightpanel.add (endTime_); 
    }

    /**
     * Return panel to parent window
     */
    public JPanel getPanel ()
    {
	return panel_;
    }

    /**
     * Set current time.
     */
    public void setCurrentTime (Date date)
    {
	String dateString = formatter_.format(date);
	currentTime_.setText (dateString);
    }

    /**
     * Set starting time.
     */
    public void setStartTime (Date date)
    {
	if (date != null) {
	    String dateString = formatter_.format(date);
	    startTime_.setText (dateString);
	}
	else
	    startTime_.setText ("");
    }

    /**
     * Set end time.
     */
    public void setEndTime (Date date)
    {
	if (date != null) {
	    String dateString = formatter_.format(date);
	    endTime_.setText (dateString);
	}
	else
	    endTime_.setText ("");
    }

    /**
     * Enable the stop button
     */
    public void enableStopButton ()
    {
	stop_.setVisible (true);
    }

    /**
     * Disable the stop button
     */
    public void disableStopButton ()
    {
	stop_.setVisible (false);
    }

    /**
     * Stop button action performed
     */
    public void actionPerformed (ActionEvent event)
    {
	disp_.stopQuery ();
    }
    
}

	

    








