//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Browser Event
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: BrowserEvent.java,v $
//   Revision 1.1  2000/01/04 14:26:09  chen
//   new implementation
//
//
//
//
package cmlog;

import java.util.*;

public final class BrowserEvent
{
    public int                       status;
    public int                       reqid;
    public int                       evid;
    public String                    verb;
    public String                    attr;
    public Packet                    packet;
    public EventListener             listener;

    /**
     * Construct an empty BrowsrEvent
     */
    public BrowserEvent ()
    {
	status = Config.CMLOG_SUCCESS;
	reqid = 93;
	evid = 1024;
	verb = null;
	attr = null;
	packet = null;
	listener = null;
    }
}
