//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiUpdateDialog class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiUpdateDialog.cc,v $
//   Revision 1.3  2000/06/20 19:36:45  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.2  1999/10/29 17:40:08  chen
//   support spaces and quotes in cmlogrc file
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.2  1999/02/02  16:05:52  chen
// add query and update selection message to configuration file
//
// Revision 1.1  1997/08/01  15:32:29  bickley
// Added cmlog to application development system.
//
//
//
#include <ctype.h>
#include <Xm/PushBG.h>
#include <Xm/LabelG.h>
#include <Xm/Form.h>
#include <Xm/TextF.h>
#include <cmlogXuiUpdate.h>
#include <cmlogXuiLogicSup.h>
#include <cmlogXuiUpdate.h>
#include <cmlogXuiConfig.h>
#include <cmlogXuiQMsgDialog.h>
#include "cmlogXuiUpdateDialog.h"

cmlogXuiUpdateDialog::cmlogXuiUpdateDialog (cmlogXuiUpdate* update,
					    const char* name,
					    const char* title,
					    cmlogXuiBrowser& browser)
:XcodaFormDialog (update->dialogBaseWidget (), name, title), 
 ok_ (0), cancel_ (0), qmsgDialog_ (0), update_ (update), browser_ (browser)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Create cmlogXuiUpdateDialog Class Object\n");
#endif
  // empty
}

cmlogXuiUpdateDialog::~cmlogXuiUpdateDialog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Delete cmlogXuiUpdateDialog Class Object\n");
#endif
}

void
cmlogXuiUpdateDialog::createFormChildren (void)
{
  Arg arg[20];
  int ac = 0;
  XmString t;

  t = XmStringCreateSimple ((char *)("Enter selection string"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  Widget title = XtCreateManagedWidget ("update_title",
					xmLabelGadgetClass, _w,
					arg, ac);
  ac = 0;
  XmStringFree (t);


  // create action form
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;  
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  Widget act_form = XtCreateWidget ("update_act_form",
				    xmFormWidgetClass,
				    _w, arg, ac);
  ac = 0;

  t = XmStringCreateSimple ((char *)("  Ok  "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNleftPosition, 5); ac++;
  XtSetArg (arg[ac], XmNshowAsDefault, 1); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  ok_ = XtCreateManagedWidget ("update_ok", xmPushButtonGadgetClass,
			       act_form, arg, ac);
  ac = 0;
  XmStringFree (t);

  t = XmStringCreateSimple ((char *)("Cancel"));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 95); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  cancel_ = XtCreateManagedWidget ("update_cancel", xmPushButtonGadgetClass,
				   act_form, arg, ac);
  ac = 0;
  XmStringFree (t);

  // create text widget
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, title); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 2) ;ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;  
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, act_form); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  logic_ = XtCreateManagedWidget ("monitor_logic_input", 
				  xmTextFieldWidgetClass,
				  _w, arg, ac);
  ac = 0;

  // create a button that launches the query message helper
  t = XmStringCreateSimple ((char *)("Help..."));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, title); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 2) ;ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;  
  XtSetArg (arg[ac], XmNleftWidget, logic_); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, act_form); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  Widget qmsgbutton = XtCreateManagedWidget ("qupdatebutton",
					     xmPushButtonGadgetClass,
					     _w, arg, ac);
  ac = 0;
  XmStringFree (t);

  XtManageChild (act_form);

  // set default button
  defaultButton (ok_);

  // add all callbacks
  XtAddCallback (ok_, XmNactivateCallback, 
		 (XtCallbackProc)&(cmlogXuiUpdateDialog::okCallback),
		 (XtPointer)this);

  XtAddCallback (cancel_, XmNactivateCallback, 
		 (XtCallbackProc)&(cmlogXuiUpdateDialog::cancelCallback),
		 (XtPointer)this);

  XtAddCallback (qmsgbutton, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiUpdateDialog::queryButtonCallback),
		 (XtPointer)this);  
}

void
cmlogXuiUpdateDialog::ok (void)
{
  char *tstr, *p;
  int  hasqstr;
  char *qstr = 0;

  // get config pointer
  cmlogXuiConfig* config = cmlogXuiConfig::config ();

  // get logic exprssion
  tstr = XmTextFieldGetString (logic_);

  if (tstr && *tstr) {
    p = tstr;
    while (*p != '\0' && *p != '\n') {
      if (!isspace (*p)) {
	hasqstr = 1;
	break;
      }
      p++;
    }
    if (hasqstr) {
      qstr = cmlogXuiQueryString (tstr);
      if (qstr == 0) {
	XtFree (tstr);
	update_->reportErrorMsg ("Selection string syntax error");
	return;
      }
      else {
	// updating configuration info about updating message string
	config->updateSelMessage (tstr);
	XtFree (tstr);
      }
    }
    else
      XtFree (tstr);
  }
  popdown ();

  update_->startUpdating (qstr);
}

void
cmlogXuiUpdateDialog::popup (void)
{
  XcodaFormDialog::popup ();
  
  cmlogXuiConfig* conf = cmlogXuiConfig::config ();
  if (conf->updateSelMessage ())
    XmTextFieldSetString (logic_, conf->updateSelMessage ());
}


void
cmlogXuiUpdateDialog::okCallback (Widget w, XtPointer data,
				 XmAnyCallbackStruct* cbs)
{
  cmlogXuiUpdateDialog* obj = (cmlogXuiUpdateDialog *)data;

  obj->ok ();
}

void
cmlogXuiUpdateDialog::cancelCallback (Widget w, XtPointer data,
				     XmAnyCallbackStruct* cbs)
{
  cmlogXuiUpdateDialog* obj = (cmlogXuiUpdateDialog *)data;

  obj->popdown ();
}

void
cmlogXuiUpdateDialog::queryButtonCallback (Widget w, XtPointer data,
					   XmAnyCallbackStruct *)
{
  cmlogXuiUpdateDialog* obj = (cmlogXuiUpdateDialog *)data;
  
  if (!obj->qmsgDialog_) {
    obj->qmsgDialog_ = new cmlogXuiQMsgDialog (obj->logic_,
					       "QueryMsgDialog",
					       "Update Message Helper");
    obj->qmsgDialog_->init();
    obj->qmsgDialog_->setModal ();
  }
  obj->qmsgDialog_->popup ();
}

