//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlog xui Top Level Window
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiTopW.cc,v $
//   Revision 1.2  2000/06/20 19:36:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:15  bickley
// Added cmlog to application development system.
//
//
//
#include <stdio.h>
#include <string.h>
#include <cmlogXuiMenuWin.h>
#include <cmlogXuiDisp.h>
#include "cmlogXuiTopW.h"

cmlogXuiTopW::cmlogXuiTopW (char* name, cmlogXuiBrowser* browser,
			    int rmBrowserOnQuit)
:XcodaTopLevel (name), window_ (0), browser_ (browser),doDeleteBrowser_(rmBrowserOnQuit)
{
#ifdef _TRACE_OBJECTS
  printf ("         Create cmlogXuiTopW Class Object\n");
#endif
  browser_->addTopLevelWindow (this);
  browser_->currentWindow (this);
}

cmlogXuiTopW::~cmlogXuiTopW (void)
{
#ifdef _TRACE_OBJECTS
  printf ("         Delete cmlogXuiTopW Class Object\n");
#endif
  // menu window will be destroyed by Xt destroy callback
  // remove this window
  browser_->removeTopLevelWindow (this);
  browser_->currentWindow (0);

  if (browser_->connected ())
    browser_->disconnect ();

  if (doDeleteBrowser_)
    delete browser_;
}

Widget
cmlogXuiTopW::CreateBaseWidget (Widget parent)
{
  window_ = new cmlogXuiMenuWin (parent, "cmlogXuiTopWindow", *browser_);
  window_->init ();
  window_->topLevelWindow (this);

  return window_->baseWidget ();
}

void
cmlogXuiTopW::connectionConfig (void)
{
  window_->connectionConfig ();
}

void
cmlogXuiTopW::disconnectConfig (void)
{
  window_->disconnectConfig ();
}

void
cmlogXuiTopW::serverCrashConfig (void)
{
  window_->serverCrashConfig ();
}


void
cmlogXuiTopW::updateTime (time_t t)
{
  window_->updateTime (t);
}

cmlogXuiDisp*
cmlogXuiTopW::displayWindow (void) const
{
  return window_->displayWindow ();
}

void
cmlogXuiTopW::forceProcessX (void)
{
  XmUpdateDisplay (_w);
}



