//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiTimeWin Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiTimeWin.cc,v $
//   Revision 1.2  2000/06/20 19:36:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:08  bickley
// Added cmlog to application development system.
//
//
//
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/LabelG.h>
#include "cmlogXuiMenuWin.h"
#include "cmlogXuiTimeWin.h"

static const char* cmlog_time_temp = "  Fri Apr 11 11:18:53 1997  "; /* 28 chars */


cmlogXuiTimeWin::cmlogXuiTimeWin (Widget parent, const char* name,
				  cmlogXuiMenuWin* win,
				  cmlogXuiBrowser& browser)
:XcodaUi (name), parent_ (parent), window_ (win), browser_ (browser)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiTimeWin Class Object\n");
#endif
  // empty
}

cmlogXuiTimeWin::~cmlogXuiTimeWin (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiTimeWin Class Object\n");
#endif
  // empty
}

void
cmlogXuiTimeWin::init (void)
{
  Widget frame0, frame1;
  Widget label0, label1;
  Arg arg[20];
  int ac = 0;
  XmString  t;

  _w = XtCreateWidget ("cmlog_time_win", xmFormWidgetClass,
		       parent_, NULL, 0);

  // left from label
  t = XmStringCreateSimple ((char *)("From "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNrecomputeSize, False); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  label0 = XtCreateManagedWidget ("cmlog_from_tlabel",
				  xmLabelGadgetClass, _w, arg, ac);
  ac = 0;
  XmStringFree (t);


  // frame for start time
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, label0); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNshadowType, XmSHADOW_IN); ac++;
  frame0 = XtCreateWidget ("cmlog_from_frame0", xmFrameWidgetClass,
			   _w, arg, ac);
  ac = 0;

  t = XmStringCreateSimple ((char *)cmlog_time_temp);
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNrecomputeSize, False); ac++;
  start_ = XtCreateManagedWidget ("cmlog_start_time",
				  xmLabelGadgetClass, frame0, arg, ac);
  ac = 0;
  XmStringFree (t);

  // To label
  t = XmStringCreateSimple ((char *)("To "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, frame0); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNrecomputeSize, False); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  label1 = XtCreateManagedWidget ("cmlog_to_tlabel",
				  xmLabelGadgetClass, _w, arg, ac);
  ac = 0;
  XmStringFree (t);


  // frame and end time window
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, label1); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNshadowType, XmSHADOW_IN); ac++;
  frame1 = XtCreateWidget ("cmlog_from_frame1", xmFrameWidgetClass,
			   _w, arg, ac);
  ac = 0;

  t = XmStringCreateSimple ((char *)(cmlog_time_temp));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNrecomputeSize, False); ac++;
  end_ = XtCreateManagedWidget ("cmlog_end_time",
				xmLabelGadgetClass, frame1, arg, ac);
  ac = 0;
  XmStringFree (t); 

  // erase labels
  t = XmStringCreateSimple ((char *)("      "));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetValues (start_, arg, ac);
  XtSetValues (end_, arg, ac);
  ac = 0;
  XmStringFree (t);
  

  XtManageChild (frame0);
  XtManageChild (frame1);

  XtManageChild (_w);

  // install destruction handler
  installDestroyHandler ();
}


void
cmlogXuiTimeWin::setStartTime (time_t t0)
{
  Arg arg[10];
  int ac = 0;
  XmString t;
  time_t temp = t0;

  if (temp >= 0)
    t = XmStringCreateSimple (ctime(&temp));
  else
    t = XmStringCreateSimple ((char *)("        "));

  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetValues (start_, arg, ac);
  ac = 0;
  XmStringFree (t);
}


void
cmlogXuiTimeWin::setEndTime (time_t t0)
{
  Arg arg[10];
  int ac = 0;
  XmString t;
  time_t temp = t0;

  if (temp >= 0) 
    t = XmStringCreateSimple (ctime(&temp));
  else
    t = XmStringCreateSimple ((char *)("       "));

  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetValues (end_, arg, ac);
  ac = 0;
  XmStringFree (t);
}


  


  
  
  
  
