//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of server information menu entry
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiSvrInfo.cc,v $
//   Revision 1.2  2000/06/20 19:36:43  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#include <XcodaApp.h>
#include "cmlogXuiMenuWin.h"
#include "cmlogXuiDisp.h"
#include "cmlogXuiTopW.h"
#include "cmlogXuiSvrInfo.h"

cmlogXuiSvrInfo::cmlogXuiSvrInfo (const char* name, int active,
				  const char* acc, const char* acc_text,
				  cmlogXuiMenuWin* win,
				  cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiSvrInfo Class Object\n");
#endif
}

cmlogXuiSvrInfo::~cmlogXuiSvrInfo (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiSvrInfo Class Object\n");
#endif
}

void
cmlogXuiSvrInfo::doit (void)
{
  char temp[128];
  
  if (browser_.connected()) 
    sprintf (temp, "CMLOG Server is located on %s at udp port %d",
	     browser_.serverHost(), browser_.serverUdpPort());
  else {
    if (browser_.serverHost())
      sprintf (temp, "CMLOG Server may be located on %s",
	       browser_.serverHost());
    else
      sprintf (temp, "No information available for CMLOG server");
  }

  disp_->reportInfoMsg (temp);
}

void
cmlogXuiSvrInfo::undoit (void)
{
  // empty
}

