//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of save settings in the preference menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiSaveSettings.cc,v $
//   Revision 1.3  2000/06/20 19:36:43  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.2  1999/09/21 20:27:56  chen
//   Add dialog box for save settings
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:03  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogXuiMenuWin.h>
#include <cmlogXuiDisp.h>
#include <cmlogXuiConfig.h>
#include "cmlogXuiSaveSettingsDialog.h"
#include "cmlogXuiSaveSettings.h"

cmlogXuiSaveSettings::cmlogXuiSaveSettings (const char* name, int active,
					    const char* acc, 
					    const char* acc_text,
					    cmlogXuiMenuWin* win,
					    cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser), dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiSaveSettings Class Object\n");
#endif
}

cmlogXuiSaveSettings::~cmlogXuiSaveSettings (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiSaveSettings Class Object\n");
#endif
}

void
cmlogXuiSaveSettings::doit (void)
{
  if (!dialog_) {
    dialog_ = new cmlogXuiSaveSettingsDialog (this, "saveSettings",
					      "cmlogSaveSettingsDialog");
    dialog_->init ();
  }
  dialog_->popup ();
}

void
cmlogXuiSaveSettings::saveSettings (char* filename)
{
  cmlogXuiConfig* config = cmlogXuiConfig::config ();
  char            message[256];

  config->windowWidth(disp_->windowWidth ());
  config->windowHeight(disp_->windowHeight());

  if (config->saveConfiguration (filename) != 0) 
    sprintf (message, "Cannot save current settings to file %s",filename);
  else
    sprintf (message, "Current settings has been saved to file %s",filename);

  reportInfoMsg (message);
}

void
cmlogXuiSaveSettings::undoit (void)
{
  // empty
}

