//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Xui Query Progress report dialog
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiQueryProg.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:55  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_QUERY_PROG_H
#define _CMLOG_XUI_QUERY_PROG_H

#include <stdio.h>
#include <string.h>
#include <XcodaFormDialog.h>
#include <cmlogXuiBrowser.h>

class cmlogXuiDisp;

class cmlogXuiQueryProg : public XcodaFormDialog
{
public:
  // constructor and destructor
  cmlogXuiQueryProg  (cmlogXuiDisp* disp, char* name, char* title,
		      cmlogXuiBrowser& browser);
  ~cmlogXuiQueryProg (void);

  // override parent class function
  void popup (void);

  // set message of this dialog
  void setMessage (char* message);

  const char* className (void) const {return "cmlogXuiQueryProg";}

protected:
  // inherited function
  void createFormChildren (void);

  // real ok button
  void ok                 (void);
  // real cancel
  void cancel             (void);
  
  // callback functions
  static void okCallback (Widget w, XtPointer data, XmAnyCallbackStruct* cbs);
  static void cancelCallback (Widget w, XtPointer data, XmAnyCallbackStruct* cbs);

private:
  // label widget
  Widget title_;
  // action button
  Widget ok_;
  Widget cancel_;
  // scale widget to specify how many to get
  Widget scale_;
  // toggle widget to specify whether to get all
  Widget toggle_;
  // Text Widget holding searching (query) message
  Widget logic_;
  
  // display window this one associates
  cmlogXuiDisp* disp_;

  // network handler
  cmlogXuiBrowser& browser_;
};
#endif
