//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of query menu in the options menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiQuery.cc,v $
//   Revision 1.2  2000/06/20 19:36:40  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:48  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogXuiQueryDialog.h>
#include <cmlogXuiMenuWin.h>
#include <cmlogXuiDisp.h>
#include "cmlogXuiQuery.h"

cmlogXuiQuery::cmlogXuiQuery (const char* name, int active,
			      const char* acc, const char* acc_text,
			      cmlogXuiMenuWin* win,
			      cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser), dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiQuery Class Object\n");
#endif
}

cmlogXuiQuery::~cmlogXuiQuery (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiQuery Class Object\n");
#endif
}

void
cmlogXuiQuery::doit (void)
{
  if (!dialog_) {
    dialog_ = new cmlogXuiQueryDialog (this,
				       "queryDialog", 
				       "Query Dialog", browser_);
    dialog_->init ();
  }
  dialog_->popup ();
}

void
cmlogXuiQuery::undoit (void)
{
  // empty
}

int
cmlogXuiQuery::doQuery (double from, double to, int numitems, 
			int getall, char* qstr)
{  
  cmlogXuiDisp* disp = menuwin_->displayWindow ();

  // if a query is already in progress, we do nothing
  if (disp->isQueryInProgress ())
    return CMLOG_ERROR;

  if (browser_.query (disp, from, to, numitems, getall, qstr)
      == CMLOG_SUCCESS) {
    // change cursor
    defineCursor (XC_watch);

    disp->cleanup ();
    menuwin_->queryConfig ();
    // set up time interval
    menuwin_->setStartTime ((time_t)from);
    menuwin_->setEndTime ((time_t)-1);

    // set query parameter to display window
    disp->numberItemsToGet (numitems);
    if (getall)
      disp->enableGetAll ();
    else
      disp->disableGetAll ();

    // set query string
    disp->queryMessage (qstr);

    // set start/end time of the search
    disp->setStartingTime (from);
    disp->setEndTime      (to);

    // set display query in progress flag
    disp->queryInProgress (1);
    return CMLOG_SUCCESS;
  }
  else {
    disp->reportErrorMsg ("Cannot send out query message !!!");
    return CMLOG_ERROR;
  }
}

