//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Query Message Dialog Box
//
//      This dialog box is created from a textfield widget.
//      Upon popdown, the desired query message will be inserted
//      into the textfield widget
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiQMsgDialog.h,v $
//   Revision 1.2  2000/06/20 19:36:40  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#ifndef _CMLOG_XUI_QMSG_DIALOG_H
#define _CMLOG_XUI_QMSG_DIALOG_H

#include <stdio.h>
#include <string.h>
#include <XcodaFormDialog.h>

class cmlogXuiSingleQMsg;
class XcodaSimpleOptionMenu;
class XcodaErrorDialog;

class cmlogXuiQMsgDialog : public XcodaFormDialog
{
public:
  // constructor
  cmlogXuiQMsgDialog  (Widget textparent, 
		       const char* name, const char* title);
  // destructor
  ~cmlogXuiQMsgDialog (void);

  // report error msg
  void reportErrorMsg (const char* msg);

  const char* className (void) const {return "cmlogXuiQMsgDialog";}

protected:
  // inherited operations
  void createFormChildren (void);

  // callback button
  static void okCallback (Widget w, XtPointer data,
			  XmAnyCallbackStruct *cbs);

  static void cancelCallback (Widget w, XtPointer data,
			      XmAnyCallbackStruct *cbs);

private:
  // parent text widget
  Widget parent_;

  // Widgets
  Widget ok_;
  Widget cancel_;

  // individual single msgs
  cmlogXuiSingleQMsg** qmsgs_;
  int                  numMsgs_;
  
  // logic options among those messages
  XcodaSimpleOptionMenu** options_;

  // error dialog
  XcodaErrorDialog*       dialog_;

  // logic options
  static const char*      logicOptions_[];
  static const char*      logicOptionNames_[];
  static int              numOptions_;
};
#endif


