//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiHelpAbout Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiHelpAbout.cc,v $
//   Revision 1.2  2000/06/20 19:36:39  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:30  bickley
// Added cmlog to application development system.
//
//
//
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <XcodaApp.h>
#include <cmlogXuiHADialog.h>
#include <cmlogXuiMenuWin.h>

#include "cmlogXuiHelpAbout.h"

cmlogXuiHelpAbout::cmlogXuiHelpAbout (const char* name, int active,
				      const char* acc, const char* acc_text, 
				      cmlogXuiMenuWin* win,
				      cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser), dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("         Create cmlogXuiHelpAbout Class Object\n");
#endif
}

cmlogXuiHelpAbout::~cmlogXuiHelpAbout (void)
{
#ifdef _TRACE_OBJECTS
  printf ("         Delete cmlogXuiHelpAbout Class Object\n");
#endif
}

void
cmlogXuiHelpAbout::doit (void)
{
  if (!dialog_) {
    dialog_ = new cmlogXuiHADialog (this, (char *)("helpAboutDialog"), 
				    (char *)("Version"));
    dialog_->init ();
  }
  dialog_->popup ();
}

void
cmlogXuiHelpAbout::undoit (void)
{
  // empty
}

