//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of disconnect menu in the file menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiDisc.cc,v $
//   Revision 1.2  2000/06/20 19:36:37  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:13  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogXuiDiscDialog.h>
#include <cmlogXuiMenuWin.h>
#include "cmlogXuiDisc.h"

cmlogXuiDisc::cmlogXuiDisc (const char* name, int active,
			    const char* acc, const char* acc_text,
			    cmlogXuiMenuWin* win,
			    cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser), dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiDisc Class Object\n");
#endif
}

cmlogXuiDisc::~cmlogXuiDisc (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiDisc Class Object\n");
#endif
}

void
cmlogXuiDisc::disconnect (void)
{
  browser_.disconnect ();
}

void
cmlogXuiDisc::doit (void)
{
  if (!dialog_) {
    char temp[80];
    sprintf (temp, "Disconnect from the cmlogServer, \n");
    strcat  (temp, "Are you sure ?");
    dialog_ = new cmlogXuiDiscDialog (this, (char *)("disconnectDialog"), 
				      (char *)("Disconnect Dialog"), 
				      browser_);
    dialog_->init ();
    dialog_->alignment (XmALIGNMENT_CENTER);
    dialog_->setMessage (temp);
  }
  dialog_->popup ();
}

void
cmlogXuiDisc::undoit (void)
{
  // empty
}

