//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Xui Simple Date Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiDate.h,v $
//   Revision 1.2  2000/06/20 19:36:37  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:12  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_XUI_DATE_H
#define _CMLOG_XUI_DATE_H

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>

typedef struct _cmlog_mon_struct_
{
  unsigned int month;
  const char*  name;
  unsigned int numdays;
}cmlogMonStruct;

class cmlogXuiTimeSel;

class cmlogXuiDate
{
public:
  // constructor
  cmlogXuiDate  (void);
  cmlogXuiDate  (unsigned int year,
		 unsigned int month,
		 unsigned int day,
		 unsigned int hour,
		 unsigned int min,
		 unsigned int sec);
  ~cmlogXuiDate (void);

  // operations
  int           set   (unsigned int year,
		       unsigned int month,
		       unsigned int day,
		       unsigned int hour,
		       unsigned int min,
		       unsigned int sec);

  // reset everything to current time
  void          reset (void);

  int           year  (unsigned int year);
  int           year  (char* year);
  unsigned int  year  (void) const;

  int           month (unsigned int month);
  int           month (char* month);
  // caller free memory
  char*         month (void) const;

  int           day   (unsigned int day);
  unsigned int  day   (void) const;

  int           hour  (unsigned int hour);
  unsigned int  hour  (void) const;

  int           minute (unsigned int min);
  unsigned int  minute (void) const;

  int           second (unsigned int sec);
  unsigned int  second (void) const;

  // string  representation: caller free memory
  char*         date   (void);

  // double representation of time
  int           date   (double& time);

protected:

  // month and day structure
  static cmlogMonStruct reg_year_struct_[];
  static cmlogMonStruct leap_year_struct_[];

  static int            num_months_;

  // fromat of date parsing
  static char*          date_format_;

  // calculate leap year
  static int leap_year (unsigned int year);

  // calendar base for localtime call
  static unsigned int base_year_;

  // given month, return numner of days in the month
  unsigned int  maxDays (unsigned int month);

private:
  // data area
  unsigned int  year_;
  unsigned int  month_;
  unsigned int  day_;
  unsigned int  hour_;
  unsigned int  minute_;
  unsigned int  second_;

  // friend class
  friend class cmlogXuiTimeSel;

  // deny access to copy and assignment operator
  cmlogXuiDate (const cmlogXuiDate& date);
  cmlogXuiDate& operator = (const cmlogXuiDate& date);
};
#endif

  
  
