//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of config file information menu entry
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiConfigInfo.cc,v $
//   Revision 1.2  2000/06/20 19:36:36  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#include <XcodaApp.h>
#include "cmlogXuiMenuWin.h"
#include "cmlogXuiConfig.h"
#include "cmlogXuiDisp.h"
#include "cmlogXuiTopW.h"
#include "cmlogXuiConfigInfo.h"

cmlogXuiConfigInfo::cmlogXuiConfigInfo (const char* name, int active,
					const char* acc, 
					const char* acc_text,
					cmlogXuiMenuWin* win,
					cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiConfigInfo Class Object\n");
#endif
}

cmlogXuiConfigInfo::~cmlogXuiConfigInfo (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiConfigInfo Class Object\n");
#endif
}

void
cmlogXuiConfigInfo::doit (void)
{
  cmlogXuiConfig* config = cmlogXuiConfig::config ();
  char* filename;
  char temp[128];
  
  if ((filename = config->configFilename()) != 0)
    sprintf (temp, "This browser is using configuration file : %s", filename);
  else
    sprintf (temp, "This browser is using default configuration");

  disp_->reportInfoMsg (temp);
}

void
cmlogXuiConfigInfo::undoit (void)
{
  // empty
}

