//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog Xui close dialog box
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiCloseDialog.h,v $
//   Revision 1.2  2000/06/20 19:36:36  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:03  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_CLOSE_DIALOG_H
#define _CMLOG_XUI_CLOSE_DIALOG_H

#include <stdio.h>
#include <string.h>
#include <assert.h>

#include <cmlogXuiBrowser.h>
#include <XcodaWarningDialog.h>

class cmlogXuiClose;

class cmlogXuiCloseDialog: public XcodaWarningDialog
{
public:
  // constructor and destructor
  cmlogXuiCloseDialog (cmlogXuiClose* close, 
		       const char* name, const char* title, 
		       cmlogXuiBrowser& browserK);
  virtual ~cmlogXuiCloseDialog (void);

protected:
  // define ok function
  virtual void ok (void);

private:
  // close command button
  cmlogXuiClose* close_;
  // network handler
  cmlogXuiBrowser& browser_;
};
#endif
