//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG XUI Browser Class
//
//      Unix environment variable CMLOG_PORT changes
//      broadcasting destination port number
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiBrowser.h,v $
//   Revision 1.2  2000/06/20 19:36:36  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:30:55  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_BROWSER_H
#define _CMLOG_XUI_BROWSER_H

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <cmlogSlist.h>
#include <cmlogUtil.h>
#include <cmlogBrowser.h>
#include <XcodaInput.h>
#include <XcodaTimer.h>

class cmlogXuiTopW;
class cmlogXuiDisp;

class cmlogXuiBrowser: public XcodaInput, public XcodaTimer
{
public:
  // constructor
  cmlogXuiBrowser              (XtAppContext context);

  // destructor
  ~cmlogXuiBrowser             (void);

  // operations

  // set default server host and server tcp port information
  void setServerTcpInfo        (char* host, unsigned short tcp_port);

  // set default server host and udp port information
  void setServerUdpInfo        (char* host, unsigned short udp_port);

  // return CMLOG_SUCCESS for success, CMLOG_ERROR for failure
  // connect to logging server
  int connect                  (int connectionRetries = 3);

  int connected                (void) const;
  // disconnect
  int disconnect               (void);

  // send query information
  int queryCallback        (char* message, cdevData& data, 
			    cmlogBrCallback cbk, void* arg);

  // remove a callback
  int    removeMonitorCallback (char* attr, 
				cmlogBrCallback callback, void* arg);

  // set up pointer for display window: 0: success, -1: error
  int addTopLevelWindow        (cmlogXuiTopW* disp);
  int removeTopLevelWindow     (cmlogXuiTopW* disp);
  int numberOfWindows          (void);

  // remember current window associated with this browser
  void currentWindow (cmlogXuiTopW* window) {window_ = window;}
  cmlogXuiTopW* currentWindow (void) const {return window_;}

  // query server from 'from' to 'to'
  // only ask for numitems of messages if getall is not true
  // with query string
  int  query                   (cmlogXuiDisp* disp, 
				double from, double to,
				int numitems, int getall,
				char* qstr);
  
  // forward operation to internal browser
  void disableTagmapNotify (void);
  void enableTagmapNotify  (void);

  // return server host information
  char* serverHost (void) const {return browser_.serverHost();}
  // return server udp port information
  unsigned short serverUdpPort (void) const {return browser_.serverUdpPort();}
  // return server tcp port information
  unsigned short serverTcpPort (void) const {return browser_.serverTcpPort();}
  

protected:
  // inherited operation from XcodaInput
  void input_callback (void);
  // inherited operation from XcodaTimer
  void timer_callback (void);

  // this function is called from disconnect callback
  void serverCrashConfig (void);
  // this function is called after one does disconnect
  void disconnectConfig  (void);
  // this function is called after network connection is established
  void connectionConfig (void);

  // update current time to all windows
  void updateTimeToWindows (time_t time);

  static void monitorTagCallback  (int status, void* arg, cmlogPacket* data);
  static void discCallback        (int status, void* arg, cmlogPacket* data);

  // some of the attributes being monitored
  static const char* tagTable_;

private:
  // real instance of cmlogBrowsers
  cmlogBrowser browser_;

  // default server host, tcp port and udp port
  char* defaultServerHost_;
  unsigned short defaultServerTcpPort_;
  unsigned short defaultServerUdpPort_;
  
  // current window associated with this browser
  cmlogXuiTopW*       window_;

  // top window list
  static cmlogSlist   wlist_;

  // flag to tell this is first one
  static int          first_;

  // deny copy and assignment operations
  cmlogXuiBrowser             (const cmlogXuiBrowser& b);
  cmlogXuiBrowser& operator = (const cmlogXuiBrowser& b);
};
#endif

  
