//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Client Daemon to CMLOG Server Connection Handler
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogUxToServer.h,v $
//   Revision 1.2  1999/11/12 17:33:04  chen
//   beta 2.0
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:30  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_UX_TO_SERVER_H
#define _CMLOG_UX_TO_SERVER_H

#include <ace/Event_Handler.h>
#include <ace/INET_Addr.h>
#include <ace/SOCK_Stream.h>
#include <ace/SOCK_Connector.h>
#include <ace/Reactor.h>
#include <cmlogMsg.h>

extern sig_atomic_t finished;

class cmlogUpIO;
class cmlogServerHB;

class cmlogUxToServer: public ACE_Event_Handler
{
public:
  // constructor
  cmlogUxToServer  (ACE_Reactor& reactor, cmlogPacket& buffer);
  // destructor
  ~cmlogUxToServer (void);

  // connect to cmlog server
  int connToServer (int reconnect = 0);
  // return connected flag
  int connectedToServer (void) const;

  // operation of reconnection
  // reconnect to cmlog server
  int reConnToServer (void);
  // close old socket before calling the above
  int closeDown (void);

  // set server udp port number
  void serverUdpPort (unsigned short port);

  // insert cmlog message to the buffer
  int insertMessageToBuffer (cmlog_cdevPacket1& msg, int size);

  // setup heart beat monitor pointer
  void serverHeartBeatMonitor (cmlogServerHB *hb);

protected:
  // inherited operation
  virtual int get_handle (void) const;
  virtual int handle_input (int);
  virtual int handle_close (int, ACE_Reactor_Mask);
  virtual int handle_timeout (const ACE_Time_Value &tv,
			      const void* arg = 0);

  // setup a timer to flush network buffer
  void        setTimerToFlush (void);

#ifdef __vxworks
  // convert a string cmlog_cdevPacket from ISR to a regular cmlog_cdevPacket
  static int  convertStrToPacket (cmlog_cdevPacket1& sp, cmlog_cdevPacket1& dp,
				  size_t& size);
  // populate a cdevData from format string + arg list with size 'size'
  static int  processString      (char* format, int* args, int size,
				  cdevData& data);
#endif

private:
  // connection socket stream to server
  ACE_SOCK_Stream toServer_;
  // Connection flag
  int             connected_;
  // timer interval to flush the buffer
  int             flushInterval_;
  // timer is on flag
  int             timerOn_;
  // UDP server heart beat monitor
  cmlogServerHB*  shb_;
  // cmlog server host
  char            serverHost_[128];
  // cmlog server udp port
  unsigned short  svr_udp_port_;
  // Reactor
  ACE_Reactor&    reactor_;
  // network buffer
  cmlogPacket&    buffer_;
};
#endif

