//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG unix client daemon user process acceptor
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogUpAcceptor.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:25  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_UP_ACCEPTOR_H
#define _CMLOG_UP_ACCEPTOR_H

#include <ace/UNIX_Addr.h>
#include <ace/LSOCK_Acceptor.h>
#include <ace/Reactor.h>
#include <cmlogProtocol.h>
#include <cdevData.h>
#include <cmlogSlist.h>
#include <cmlogMsg.h>
#include <cmlogUxToServer.h>

class cmlogUpIO;

class cmlogUpAcceptor: public ACE_Event_Handler
{
public:
  // constructor: global reactor + network buffer + to server stream
  cmlogUpAcceptor        (ACE_Reactor& reactor, cmlogPacket& buffer,
			  cmlogUxToServer& toServer);
  // destructor
  ~cmlogUpAcceptor       (void);

  // open local UNIX socket address
  int open               (void);
  // return number of process connection
  int numberOfConnections(void);
  // remove a connection from the list
  int remove             (cmlogUpIO* conn);

  // return local file path for unix socket
  char* socketPath       (void);

  // return all process list
  cmlogSlist& connectionList (void);

  // inherited operations
  virtual int get_handle  (void) const;
  virtual int handle_close (int fd, ACE_Reactor_Mask);
  virtual int handle_input (int fd);

private:
  // Reactor
  ACE_Reactor& r_;
  // network buffer
  cmlogPacket& buffer_;
  // TCP connection to central server
  cmlogUxToServer& toServer_;
  // unix socket
  ACE_LSOCK_Acceptor upAcceptor_;
  // UNIX local path for unix socket
  char           upSocketPath_[128];
  // connection list for all logging processes
  cmlogSlist     connList_;
};
#endif

  
