//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog Server Query Connection Acceptor
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogQueryAcceptor.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
//
//
#ifndef _CMLOG_QUERY_ACCEPTOR_H
#define _CMLOG_QUERY_ACCEPTOR_H

#include <cmlogDatabase.h>
#include <cmlogAcceptor.h>

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
#include <cpThreadManager.h>
#else
#include <cpProcessManager.h>
#endif

class cmlogQueryIO;

class cmlogQueryAcceptor: public cmlogAcceptor
{
public:
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  // constructor and destructor
  cmlogQueryAcceptor  (ACE_Reactor& r, cpThreadManager& manager);
#else
  // constructor and destructor
  cmlogQueryAcceptor  (ACE_Reactor& r, cpProcessManager& manager);
#endif

  ~cmlogQueryAcceptor (void);

protected:
  // inherited operations
  virtual int handle_input (int fd);

private:
  // process or thread manager
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cpThreadManager& manager_;
#else
  cpProcessManager& manager_;
#endif
};

#endif
