//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog UDP Port Handler
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogPortHandler.cc,v $
//   Revision 1.2  2001/07/25 14:30:20  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:13  bickley
// Added cmlog to application development system.
//
//
#include <cmlogUtil.h>
#include "cmlogPortHandler.h"

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
void *
cmlogPortHandler::portHandlerThread (void *arg)
{
  cmlogPortHandler* obj = (cmlogPortHandler *)arg;

  for (;;)
    obj->handle_input (0);

  return 0;
}
#endif

cmlogPortHandler::cmlogPortHandler (ACE_Reactor& r, int primary)
:reactor_ (r), brdcastListener_ (), clientAcceptorPort_ (0), 
 browserAcceptorPort_ (0), adminAcceptorPort_ (0), primary_ (primary)
{
#ifdef _TRACE_OBEJCTS
  printf ("Create cmlogPortHandler Class Object\n");
#endif
}

cmlogPortHandler::~cmlogPortHandler (void)
{
  handle_close (-1, ACE_Event_Handler::READ_MASK);
}

int
cmlogPortHandler::open (int async)
{
  int port;
  
  port = cmlogUtil::PORT;

  ACE_INET_Addr    brdAddr ((unsigned short)port);

  if (brdcastListener_.open (brdAddr) == -1)
    return -1;
  else if (async && brdcastListener_.enable (SIGIO) == -1)
    return -1;
  else
    return 0;
}

unsigned short
cmlogPortHandler::port_number (void)
{
  ACE_INET_Addr addr;

  int status = brdcastListener_.get_local_addr (addr);
  
  /* already has right byte order */
  return addr.get_port_number ();
}

void
cmlogPortHandler::clientAcceptorPort (unsigned short portnum)
{
  clientAcceptorPort_ = portnum;
}

void
cmlogPortHandler::browserAcceptorPort (unsigned short portnum)
{
  browserAcceptorPort_ = portnum;
}

void
cmlogPortHandler::adminAcceptorPort (unsigned short portnum)
{
  adminAcceptorPort_ = portnum;
}

int
cmlogPortHandler::svcReply (ACE_INET_Addr& reqAddr, unsigned short port)
{
  int status;
  unsigned short tmp = htons (port);
  status = brdcastListener_.send (&tmp, sizeof (tmp), reqAddr);
  if (status == -1) {
#ifdef _CMLOG_DEBUG
    fprintf (stderr, "Cannot send back broadcast reply to the client\n");
#endif
  }
  if (status > 0)
    return 0;
  else
    return -1;
}

int
cmlogPortHandler::handle_close (int, ACE_Reactor_Mask)
{
  return brdcastListener_.close ();
}

int
cmlogPortHandler::get_handle (void) const
{
  return brdcastListener_.get_handle ();
}

int
cmlogPortHandler::handle_input (int)
{
  ACE_INET_Addr sa;
  int           n;
  unsigned      type;
  char          brdrecvbuf[128];
  
  if ((n = brdcastListener_.recv (brdrecvbuf, sizeof (brdrecvbuf), sa)) == -1)
    return -1;
  else {
    if (primary_) {
      memcpy (&type, brdrecvbuf, sizeof (unsigned));
      int i = sizeof (unsigned);
      type = ntohl (type);
      switch (type){
      case CMLOG_CLNTLKSVC:
#ifdef _CMLOG_DEBUG
	printf ("Client is looking for me\n");
#endif
	return svcReply (sa, clientAcceptorPort_);
	break;
      case CMLOG_BRSERLKSVC:
#ifdef _CMLOG_DEBUG
	printf ("Browser is looking for me\n");
#endif
	return svcReply (sa, browserAcceptorPort_);
	break;
      case CMLOG_ADMINLKSVC:
#ifdef _CMLOG_DEBUG
	printf ("Admin task is looking for me\n");
#endif
	return svcReply (sa, adminAcceptorPort_);
	break;
      default:
#ifdef _CMLOG_DEBUG
	printf ("Who knows where this comes from\n");
#endif
	break;
      }
    }
  }
  return 0;
}

    
  
