//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server/client Admin IO handler
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogAdminIO.h,v $
//   Revision 1.2  1999/12/13 21:24:39  chen
//   Add more error checking using BAD_PTR
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:28:44  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_ADMIN_IO_H
#define _CMLOG_ADMIN_IO_H

#include <cmlog_cdevMessage.h>
#include <cmlog_cdevTagMap.h>
#include <cmlogSlist.h>
#include <cmlogIO.h>
#include <cmlogMsg.h>
#include <cmlogDatabase.h>


class cmlogAdminIO: public cmlogIO
{
public:
  // constructor and destrcutor
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cmlogAdminIO  (ACE_Reactor& r, 
		 cmlogDataQueue* dataqueue);
#else
  cmlogAdminIO  (ACE_Reactor& r, 
		 cmlogDataQueue* dataqueue,
		 cmlogDataQueue* comdqueue);
#endif
  ~cmlogAdminIO (void);

protected:
  // inherited operation for handle_input
  virtual int handle_input (int fd);

  // inherited operation for handle_close
  virtual int handle_close (int fd, ACE_Reactor_Mask);

  // reader operation: called by handle_input
  int         reader       (void);

  // process cmlogPacket data
  int         processData           (cmlogPacket& packet);

private:
  // deny access to copy and assignment operator
  cmlogAdminIO (const cmlogAdminIO &io);
  cmlogAdminIO& operator = (const cmlogAdminIO &);
};

#endif
