/* test program using c interface */
#include <stdio.h>
#include <string.h>
#include <cmlog.h>

#ifndef __vxworks
main (int argc, char** argv)
#else
client_test (char* name)
#endif
{
  int status;
  cmlog_client_t cl;
  int i = 0;
  char message[256];

#ifndef __vxworks
  cl = cmlog_open (argv[0]);
#else
  cl = cmlog_open (name);
#endif

  if (cl == 0) {
    fprintf (stderr, "cannot open cmlog client\n");
    exit (1);
  }

  for (i = 0; i < 10000; i++) {
    sprintf (message, "Error generated by c interface at %d\n", i);
    status = cmlog_logmsg (cl, 32, 12, CMLOG_ERROR,
			   "EPICS", "value = %d status = %d text = %s",
			   i*10, 0, message);
#ifndef __vxworks
    sleep (1); 
#else
    taskDelay (sysClkRateGet ());
#endif
  }

  cmlog_close (cl);
}

