/*
//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG user program header file (+ c interface)
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlog.h,v $
//   Revision 1.2  1999/09/20 17:00:19  chen
//   get CODA fix in
//
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.2  1998/06/16  17:29:54  chen
// fix decleration on cmlog_logtext
//
// Revision 1.1  1997/08/01  15:27:03  bickley
// Added cmlog to application development system.
//
//
//
*/
#ifndef _CMLOG_H
#define _CMLOG_H

/* The following are the same as CDEV error code                            */
#define CMLOG_SUCCESS        0
#define CMLOG_ERROR          -1

#define CMLOG_INVALIDOBJ     1  /* invalid cdev objects                     */
#define CMLOG_INVALIDARG     2  /* invalid argument passed to cdev calls    */
#define CMLOG_INVALIDSVC     3  /* wrong service during dynamic loading     */

#define CMLOG_NOTCONNECTED   4  /* not connected to low network service     */
#define CMLOG_IOFAILED       5  /* low level network service IO failed      */
#define CMLOG_CONFLICT       6  /* conflicts of data types or tags          */
#define CMLOG_NOTFOUND       7  /* cdev cannot find user request (cdevData) */

#define CMLOG_TIMEOUT        8  /* time out                                 */
#define CMLOG_CONVERT        9  /* cdevData conversion error                */
#define CMLOG_OUTOFRANGE    10  /* value out of range for device attribute  */
#define CMLOG_NOACCESS      11  /* insufficient access to perform request   */
#define CMLOG_ACCESSCHANGED 12  /* change in access permission of device    */

#define CMLOG_DISCONNECTED  60  /* channel has been disconnected            */
#define CMLOG_RECONNECTED   61  /* channel has been reconnected             */

/* The following are unique to the CMLOG                                    */
#define CMLOG_NOTCONSERVER  80  /* can not connect to server/ not connected  */
#define CMLOG_NOTFOUNDSERVER 81 /* can not find server                       */
#define CMLOG_CONN_TIMEOUT   82 /* connection timeout                        */
#define CMLOG_FILTERED       83 /* messages have been filtered               */
#define CMLOG_NOFILTERING    84 /* no filtering applied                      */
#define CMLOG_DROPPED        85 /* message is dropped                        */
#define CMLOG_BADIO          86 /* TCP io is bad file descriptor             */
#define CMLOG_OVERFLOW       87 /* query message overflow buffer             */
#define CMLOG_INCOMPLETE     88 /* data flow will coming (unfinished)        */
#define CMLOG_CBK_FINISHED   89 /* callback finished (monitor off)           */
#define CMLOG_PAUSED         90 /* query callback is paused                  */
#define CMLOG_QUERYMSG_ERR   91 /* query message syntax error                */
#define CMLOG_THREAD_ERR     92 /* query thread init error                   */
#define CMLOG_QUERY_CANCELED 93 /* query service is canceled                 */

#define CMLOG_IOERROR        CMLOG_IOFAILED
#define CMLOG_INVALID        CMLOG_INVALIDARG

typedef long                 cmlog_client_t;

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 *              C interface for cmlogClient                                  *
 ****************************************************************************/

/* creation and allocation of cmlog_client_t                                */
/* return 0: failure, anything else success                                 */
extern cmlog_client_t cmlog_open (char* progname);

/* log message to cmlog server                                              */
/* return CMLOG_SUCCESS: success, anything else failure                     */
extern int  cmlog_logmsg (cmlog_client_t client, int verbosity,
			  int severity, int code, char* facility,
			  char* format, ...);

/* log message to cmlog server                                              */
/* return CMLOG_SUCCESS: success, anything else failure                     */
extern int  cmlog_logtext (cmlog_client_t client, char* format, ...);

/* set/get severity threshold                                               */
extern int  cmlog_set_severity_threshold (cmlog_client_t client, 
					  int threshold);
extern int  cmlog_get_severity_threshold (cmlog_client_t client,
					  int *threshold);

/* set/get verbosity threshold                                              */
extern int  cmlog_set_verbosity_threshold (cmlog_client_t client, 
					   int threshold);
extern int  cmlog_get_verbosity_threshold (cmlog_client_t client,
					   int *threshold);

/* set throttle on a particular tag: one tag one client for now            */
extern int  cmlog_set_throttle (cmlog_client_t client,
				char* tag, int valuerange,
				int limit, double interval);
extern int  cmlog_get_throttle (cmlog_client_t client,
				char** tag, int* valuerange,
				int* limit, double* interval);


#ifdef __vxworks
/* log message to cmlog server inside ISR                                   */
extern int  cmlog_logmsgI (cmlog_client_t client,
			   int verbosity, int severity, 
			   int code, char* facility,
			   char* format, int arg0, int arg1,
			   int   arg2,   int arg3, int arg4,
			   int   arg5);

/* log text to cmlog server inside ISR                                      */
extern int  cmlog_logtextI (cmlog_client_t client,
			    char* format, 
			    int arg0, int arg1,
			    int   arg2,   int arg3, int arg4,
			    int   arg5,   int arg6, int arg7,
			    int   arg8,   int arg9);
#endif

/* close client connection to the server                                    */
extern void cmlog_close  (cmlog_client_t client);

#ifdef _CODA_DALOG
/* The following are for CODA use only                                      */
extern int  daLogOpen     (char *name, char *type);

#ifdef __vxworks
extern void daLogMsg      (char *sev,char *fmt,
                           int a,int b,int c,int d,int e,int f,int g,
                           int h,int i);
#else
extern void daLogMsg      (char *sev,char *fmt,...);
#endif

extern void daLogMsgI     (char *sev,char *fmt,
			   int a,int b,int c,int d,int e,int f,int g,
			   int h,int i);

extern void daLogMsg2     (char *name,char *sev,char *fmt,
			   int a,int b,int c,int d,int e,int f,
			   int g,int h,int i);
#endif
 
#ifdef __cplusplus
};
#endif

#endif

