//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogQUpdateObj Class
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: cmlogQUpdateObj.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/09/18  14:28:57  chen
// new cmlog query service
//
//
//
#include "cmlogQUpdateObj.h"

//=========================================================================
//         Implementation of cmlogQUpdateObj
//=========================================================================
cmlogQUpdateObj::cmlogQUpdateObj (cdevTranObj& tranObj)
:system_ (tranObj.system_), reqObj_ (tranObj.reqObj_),
 resultData_ (tranObj.resultData_), userCallback_ (tranObj.userCallback_),
 tobj_ (&tranObj)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogQUpdateObj Class Object\n");
#endif
  // empty
}

cmlogQUpdateObj::~cmlogQUpdateObj (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogQUpdateObj Class Object\n");
#endif
  if (userCallback_ != 0) {
#ifdef _CMLOG_DEBUG
    printf ("Delete userCallback inside cmlogQUpdateObj\n");
#endif
    delete userCallback_;
  }
  userCallback_ = 0;
}
