//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//     CMLOG Client Request Object
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: cmlogRequestObject.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:26:27  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_REQUEST_OBJECT_H
#define _CMLOG_REQUEST_OBJECT_H

#include <cdevSystem.h>
#include <cdevRequestObject.h>

class cmlogClient;
class cmlogService;

class cmlogRequestObject: public cdevRequestObject
{
public:
  // constructor and destructor
  cmlogRequestObject (char* device,
		      char* msg,
		      cmlogService* svc,
		      cdevSystem& system = cdevSystem::defaultSystem());
  ~cmlogRequestObject (void);

  int setContext (cdevData& cxt);
  // PURPOSE: set io context to this request object.
  //          Redefine setContext inherited from cdevIOcontext
  // REQUIRE: nothing
  // PROMISE: value tag will be always set, return CDEV_SUCCESS

  int send (cdevData& out, cdevData& result);
  int send (cdevData *out, cdevData& result);
  int send (cdevData& out, cdevData* result);
  int send (cdevData *out, cdevData* result);
  // PURPOSE: Synchronous IO operations "get", "set", "monitorOn/off"
  // REQUIRE: When set, out must be supplied. When get result must be provided
  // PROMISE: return CDEV_SUCCESS: success. 
  //          There will be no synchronous monitorOn.

  int sendNoBlock (cdevData& out, cdevData& result);
  int sendNoBlock (cdevData* out, cdevData& result);
  int sendNoBlock (cdevData& out, cdevData* result);
  int sendNoBlock (cdevData* out, cdevData* result);
  // PURPOSE: Asynchronous IO operations used in conjunction with cdevGroup or system
  // REQUIRE: When set, out must be supplied. When get result must be provied.
  //          Caller must call system.pend or group.pend to flush out network
  //          requests.
  // PROMISE: return CDEV_SUCCESS: requests have been sent out. 

  int sendCallback (cdevData& out, cdevCallback& callback);
  int sendCallback (cdevData* out, cdevCallback& callback);
  // PURPOSE: Asynchromous IO operations with a user supplied callback function
  // REQUIRE: When set, out must be provided.
  // PROMISE: User callback function will be called with status information
  //          status = CDEV_DISCONNECTED: channel discconected
  //          status = CDEV_SUCCESS     : everything is OK
  //          status = CDEV_RECONNECTED : channel reconnected
  //          status = CDEV_ERROR       : something fishy. 

  int getState (void);
  // PURPOSE: get connection state
  // REQUIRE: none
  // PROMISE: CDEV_CONNECTED or CDEV_NOTCONNECTED

  const char *className (void) const {return "cmlogRequestObject";}

private:
  // flag of context
  int contextSet_;

  // pointer of underlying client connection
  cmlogClient* client_;
};
#endif

  
