//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	XcodaToplevel Window Class
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: XcodaTopLevel.h,v $
//   Revision 1.2  2000/06/20 18:46:23  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:08  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:25:22  bickley
// Added cmlog to application development system.
//
//   Revision 1.2  1997/04/16 18:12:22  chen
//   add multilist and extensions
//
//   Revision 1.1.1.1  1996/10/10 19:24:59  chen
//   coda motif C++ library
//
//
#ifndef _XCODATOPLEVEL_H
#define _XCODATOPLEVEL_H

#include <XcodaUi.h>

class XcodaTopLevel: public XcodaUi
{
public:
  virtual ~XcodaTopLevel();
    
  // The Application class automatically calls initialize() 
  // for all registered main window objects
    
  virtual void initialize (void);
  // popup the window
  virtual void manage     (void);   
  // pop down the window
  virtual void unmanage   (void); 
  virtual void iconify    (void);
  // change cursor
  virtual void defineCursor (unsigned int cursor);
  virtual void undefineCursor (void);
  
protected:
  // Constructor requires only a name.  protect from direct instance
  XcodaTopLevel ( const char *name );   
  Widget _base_widget;
  // Derived classes must define this function to
  // create form or rowcolumn...
  virtual Widget CreateBaseWidget (Widget parent) = 0;
};
#endif
