//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	 Reactor Timer Internal Representation
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: reactorTimerRep.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:06  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:22:54  bickley
// Added cmlog to application development system.
//
//
#ifndef _REACTOR_TIMER_REP_H
#define _REACTOR_TIMER_REP_H


#include <ace/Reactor.h>
#include <ace/Event_Handler.h>

class reactorTimer;

class reactorTimerRep: public ACE_Event_Handler
{
  friend class reactorTimer;
public:
  // Destructor
  ~reactorTimerRep (void);
  // inherited from event handler
  virtual int handle_timeout (const ACE_Time_Value &tv, const void *arg = 0);
  virtual int get_handle (void) const;

 private:
  // constructor 
  reactorTimerRep (void);
  // register real timer 
  void timerSelf (reactorTimer *timer);
  // some communication between timer and timeRep
  void counter (int cnter);
  int  counter (void) const;
  void interval (int val);
  int  interval (void) const;
  // data area
  reactorTimer *realTimer_;
  int     counter_;
  int     interval_;
};
#endif
