/* -*- C++ -*- */

// ============================================================================
//
// = LIBRARY
//    ace
// 
// = FILENAME
//    ACE_Date_Time.h
//
// = AUTHOR
//    Tim Harrison (harrison@cs.wustl.edu) (and he's darn proud of this ;-))
// ============================================================================

#if !defined (ACE_DATE_TIME_H)
#define ACE_DATE_TIME_H

#include "ace/ACE.h"

class ACE_Date_Time
  // = TITLE
  //     System independent representation of date and time.
{
public:
  // constructor with init values, no check for validy
  ACE_Date_Time (long day = 0,
		 long month = 0,
		 long year = 0,
		 long hour = 0,
		 long minute = 0,
		 long second = 0,
		 long microsec = 0);

  // set/get portions of ACE_Date_Time, no check for validy

  long day (void);
  // get day

  void day (long day);
  // set day

  long month (void);
  // get month

  void month (long month);
  // set month

  long year (void);
  // get year

  void year (long year);
  // set year

  long hour (void);
  // get hour

  void hour (long hour);
  // set hour

  long minute (void);
  // get minute

  void minute (long minute);
  // set minute

  long second (void);
  // get second

  void second (long second);
  // set second

  long microsec (void);
  // get microsec

  void microsec (long microsec);
  // set microsec

private:
  long day_;
  long month_;
  long year_;
  long hour_;
  long minute_;
  long second_;
  long microsec_;
};

#include "ace/Date_Time.i"

#endif /* ACE_DATE_TIME_H */
