//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Simple cmlog browser java test
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogClient.java,v $
//   Revision 1.2  2000/03/17 19:57:54  chen
//   minor change
//
//   Revision 1.1  2000/03/17 19:16:51  chen
//   Simple Client Test
//
//   Revision 1.2  2000/01/04 18:57:07  chen
//   Bug fixes for unsigned short port number
//
//   Revision 1.1  2000/01/04 14:26:08  chen
//   new implementation
//
//
//
//
import cmlog.*;

import java.io.*;
import java.net.*;
import java.text.*;
import java.util.*;


public class cmlogClient
{
    public static void main (String[] args)
    {
	if (args.length < 1) {
	    System.err.println ("Usage: cmlogClient protovesion(1 or 2) [debug]");
	    System.exit (1);
	}
	Config.PROTOCOL_MAJOR_VERSION = Integer.valueOf (args[0]).intValue();
	if (args.length >= 2) {
	    String tstring = args[1];
	    if (tstring.compareTo ("debug") == 0)
		Config.debug = true;
	}
	
	Client client = new Client("cmlogClient");

	try {
	    client.connect ();
	}catch (ConnectException ce) {
	    System.err.println (ce);
	}catch (IOException e) {
	    System.err.println (e);
	}

	cdevData data = new cdevData ();
	String   val;

	for (int i = 0; i < 100000; i++) {
	    val = new String ("New error message is generated by java at " + String.valueOf (i));
	    data.remove();
	    data.insert ("status", i%10);
	    data.insert ("severity", i%20);
	    data.insert ("facility", "javatest");
	    data.insert ("text", val);
	    
	    try {
		client.postData (data);
	    }catch (IOException e) {
		System.err.println (e);
		break;
	    }

	    try {
		Thread.sleep (1000);
	    }catch (InterruptedException e) {
		;
	    }
	}
	try {
	    client.disconnect ();
	}catch (IOException e) {
	    ;
	}
    }
}

       
