/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Image Icon Utility
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: Util.java,v $
 *   Revision 1.1  2001/10/19 18:16:12  chen
 *   Change how image is loaded
 *
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.util.*;

import cmlog.*;

public class Util
{
    /**
     * Image for stop icon file
     */
    private static final String stopfile = "cmlog/gui/StopImage.gif";


    /**
     * Image file shows as log icon.
     */
    private static final String logfile = "cmlog/gui/cmlog.gif";


    /**
     * Image Byte in Integer form for cmlog log.
     */
    public static final int[] logbytes = {1651, 1195984440, 962674688, -2147449856, 0, -858993504, -1599831936, -2132943395, -1061109505, -68091905, -16729344, -10079420, 1145346559, 863467383, -1717987055, 286335522, 576017749, 11141273, -65536, -65536, 10027110, -13369345, -1, -1, -1, -1, -1, -1, -14549490, 1298228325, 544696692, 1746945865, 1297088545, -117178102, 2031660, 0, 1073774592, 392928, 663643241, -1637307730, 1827389040, 751793261, -1488933153, -1380009088, -2141181928, 7907872, -1317510143, 142754356, 1782881950, 1399431578, 873774816, 802630146, 2026102961, 158349328, 235275105, 1578120877, 1815567438, -1213999098, 33620993, -2057614236, 528515716, -2046588841, 1879215361, 1653635218, -1802081756, -1953152101, 2001247826, 1367841827, -1955368700, -1482539862, 78425727, -1836870251, -1884801378, -2072660847, 1917558935, -1552920381, 1388022471, -1214929461, 880837773, 1598278611, -2075930683, -1329079678, -690434814, 1926683959, -750590256, -1347821819, -1385699140, -252517650, 1707977703, -785126660, -623517101, -392580484, 900863236, 1133484444, 1091047548, 1781034335, -997596408, 642302160, -1626569445, 992085128, 1260394898, -1073828211, -55177121, 579176028, 111367762, -439648971, 465712200, -249574504, 117953100, -638377138, -1575360588, 209383975, -811288688, 38850804, -1590719405, 1732401584, -1596636923, 1418588433, -1059771629, -1335113579, 1829189228, 984964569, -1561476046, 238494573, -584668053, -521218890, 1948194500, -1697145888, -2060842121, -222218233, 1614581031, 1215708247, -2056992470, 912973384, 1651737106, -1639490402, 274985993, -811513948, 1455249908, -439177407, 1798762841, 82497197, 1566803553, 439871436, -1421933329, -41764627, -641699061, 522107768, -203047021, 593432221, -2064574778, -1488191603, -1162442517, 747121487, 823867879, -236955768, -678518020, 1844898093, 924835742, 2070870223, -1311807617, -629246724, -1153886368, 1895683446, 528524529, -17425279, -565086308, 2012530071, 1115086185, -1501330119, 1288150916, 679499553, 818337, -652800772, 1348274460, -1631559410, 1587667298, -1995932265, 1601713062, -765323149, -1399692501, 625891491, 2080478960, 68856772, -1052077764, 580166153, -250758749, -1854111711, -1959198168, -106721471, 1991395867, 1187959128, 1662869017, 1721120282, -1071309354, -57321637, 1452452318, -1895811888, 625189032, -373254362, 780739228, 222585252, -1962607387, -2147237108, -243268678, 623419554, 1110053061, 22211608, -967569880, 1088950797, 479864940, 1848308416, -1554893792, -1431827392, 1441941, 1513784488, 238059688, -1935842615, -1466560448, 11075747, -1838503422, -1464412694, -1582973190, -2120296719, 1228932021, 1116760835, -1516332502, 1487771306, 699184126, -768025931, 331626953, 479805152, 1835257690, 1521156624, 139160738, -665921945, 26273416, -971981318, 1789526800, -1537479269, -161548759, -1147017510, 749723962, 1885908470, 1922756356, 81033963, -1291860469, 1840385812, -61733945, 650899630, 244018026, -1108793694, 1218394486, -80911615, -816075065, 1470946094, -1703647700, 817702819, 753188363, -74747447, -922080397, 420076506, -274199069, 214021179, -1757335118, -1252070292, 1580241835, -204547450, -319961026, -1809027419, 1159400874, -1151221733, -255793686, 632534780, -496323661, 14982252, -657898995, 27813379, 2108929973, -1034143815, -1256809162, 1128923964, 683505167, -1166617031, -1138903122, -1487999507, -545124450, -1256028753, 221315210, 1541060835, -1886715805, -630500418, -1494942087, 658693897, 282900061, 1949601006, 1535489109, -660599638, -1279864358, -192020870, 212943767, -2132493621, 2117799857, -1211712654, -1177087748, 1824758727, 521324503, -1766031566, 938474720, -1391104004, -222461968, -58478757, -1081936862, 1216225514, -643330435, 1860315983, -1091054891, -149164774, -1903690485, -626153024, 1719197615, -644178271, 897518510, -616002046, -1736434419, -797624800, -1610526365, -1073302834, 1661638723, 1530939329, 172130305, 316430596, 161513480, 350224671, 77707074, -133885766, -2008802924, -653912800, -2129216784, -2060415967, 51912705, 208818307, 311705761, -1777286377, -827292119, 1155074677, -658491128, -1601752564, 570717112, -1380640495, -1993296735, -657968956, 1844784199, 1205133582, -1289206500, 1922074693, -857497047, -556416466, -1433368316, -1734272463, 684065356, -1610607520, 1209636248, -2010507759, 170726592, 467912775, 785551754, 1750917900, -240630984, -1160671106, -1126098497, 1749353354, 831414136, -486272455, 1160501297, -1938209597, 455731525, 376336648, 2044486149, -2136455135, -435123544, 1826695373, 1749683942, -981290820, -534827719, -2029462287, -1773816640, 747745345, 182514327, 229418021, -314061726, 372470559, 1352413847, -917737695, 1392821900, 640786409, -1471194509, 163714274, 271347789, 573076232, -648273360, 2132397626, 304087673, 430375371, 155738026, -1282872292, 1714677673, -859151250, -2081465113, 866200013, 2129589151, 895040, 126518288, 15104};


    /**
     * Image bytes presented by integer for stop icon in gif format.
     */
    public static final int[] stopbytes = {203, 1195984440, 962666496, 536912128, 8388608, -16777088, 8454143, -14550780, 16777219, 2883584, 8192, 536870914, -1667461207, -873656413, 480303707, 667081834, 1510335048, -1967102827, -361217303, 179817739, -948741913, -233432510, -1862731452, -2015375664, 319293130, 1704192260, 714719300, 1380645985, -1453547243, -2141886777, -571664565, -1569815060, 707768404, -1546959377, 454991287, -1587935890, -1397254538, 1444304968, 1155032744, -1996990808, 1185404280, 269625222, 1724508342, 567424114, -1985542694, -1873560903, 1611273105, 1513275706, -1181025695, 1614441339, -1952732336, 15104};

    /**
     * Convert image file to integer byte (quick hack)
     */
    public static void imageByte (String imgfile)
    {
	FileInputStream input = null;
	
	try {
	    input = new FileInputStream ((imgfile));
	}catch (Exception e) {
	    System.err.println (e.getMessage());
	    return;
	}
	
	int i = 0;
	byte[] buffer = new byte[8192];
	int    len;

	for (i = 0; i < 8192; i++)
	    buffer[i] = (byte)0;

	try {
	    len = input.read (buffer);
	}catch (Exception e) {
	    System.err.println (e.getMessage());
	    return;
	}
	
	
	if (len == -1)
	    return;

	System.out.println ("Total bytes receivied is " + String.valueOf(len));

	int  intlen = len/4 + 1;
	int[]  res = new int[intlen];

	ByteArrayInputStream binput = new ByteArrayInputStream (buffer,
								0 , (len/4 + 1)*4);
	DataInputStream dinput = new DataInputStream (binput);
	
	try {
	    for (i = 0; i < intlen; i++) {
		res[i] = dinput.readInt ();
		System.out.print (" " + String.valueOf (res[i]) + ",");
	    }
	}catch (IOException e) {
	    System.err.println (e.getMessage());
	}
	System.out.println (" ");
    }


    /**
     * Convert integer array into image bytes.
     *
     * First element of the integer array is the length of byte array to
     * produce.
     */
    public static byte[] imageByte (int[] array)
    {
	int i;
	int bytelen = array[0];
	byte[] buffer = new byte[bytelen];

	// create a data output stream to write all this integers out
	ByteArrayOutputStream bout = new ByteArrayOutputStream ();
	DataOutputStream dout = new DataOutputStream (bout);

	try {
	    for (i = 1; i < array.length; i++)
		dout.writeInt (array[i]);
	}catch (IOException e) {
	    System.err.println (e.getMessage());
	    return null;
	}
	
	// now copy data back into buffer
	byte[] tmp = bout.toByteArray ();
	for (i = 0; i < bytelen; i++)
	    buffer[i] = tmp[i];

	return buffer;
    }
}
