/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Update Dialog for cmlog browser
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: UpdateDialog.java,v $
 *   Revision 1.1  2001/10/18 18:45:43  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import cmlog.*;

public class UpdateDialog extends JDialog implements ActionListener
{
    /**
     * Internal OK button.
     */
    private JButton ok_;

    /**
     * Internal cancel button.
     */
    private JButton cancel_;

    /**
     * Help button.
     */
    private JButton help_;

    /**
     * Text input field
     */
    private JTextField input_;

    /**
     * Display associated with this dialog.
     */
    private Disp disp_;

    /**
     * Menu item that invokes this dialog.
     */
    private JCheckBoxMenuItem parent_ = null;

    /**
     * Dialog box for generating selection message.
     */
    private SelectionMsgDialog smsgDialog_ = null;


    /**
     * Constructor.
     */
    public UpdateDialog (Disp disp, JCheckBoxMenuItem item)
    {
	super (disp.getParentWindow(),
	       "CMLOG Update Selection String", true);
	
	disp_ = disp; 
	parent_ = item;
	
	JPanel manager = new JPanel ();
	manager.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
	manager.setLayout(new BorderLayout(10, 10));
	
	// create a Label
	Font defont = getFont();
	Font newfont = defont.deriveFont (Font.BOLD);
	JLabel title = new JLabel ("Enter Selection String");

	title.setFont (newfont);
	manager.add(title, BorderLayout.NORTH);	


	// put configuaration update message into the text field.
	// Since I have not found a quick way to verify syntax of
	// user input, I will allow user input in the next version

	// create input panel
	JPanel ipanel = createInputPanel ();
	manager.add (ipanel, BorderLayout.CENTER);

	// create button panels
	JPanel buttonpanel = createButtons ();
	manager.add(buttonpanel, BorderLayout.SOUTH);

	// put panel into content pane
	Container cpn = getContentPane ();
	cpn.add (manager);

	getRootPane().setDefaultButton(ok_);

	// create selection dialog box
	smsgDialog_ = new SelectionMsgDialog (disp_, input_);
    }

    /**
     * Create searching message input panel.
     */
    private JPanel createInputPanel ()
    {
	JPanel panel = new JPanel ();
	Box    box  = Box.createHorizontalBox ();

	input_ = new JTextField (30);
	input_.setEditable (false);
	box.add (input_, BorderLayout.CENTER);
	
	Component tmp = box.createHorizontalGlue ();
	box.add (tmp);

	help_ = new JButton ("Help...");
	help_.addActionListener (this);
	box.add (help_);

	panel.add (box);
	return panel;
    }

    /**
     * Create button panels
     */
    private JPanel createButtons ()
    {
	// grid layout 1 row 3 column, 20 hgap, 0 vgap
	GridLayout bl = new GridLayout (1, 2, 30, 0);
	JPanel panel = new JPanel (bl);

	// create ok button
	ok_ = new JButton ("Ok");
	panel.add (ok_);

	// create cancel button 
	cancel_ = new JButton ("Cancel");
	panel.add (cancel_);


	// add action listener
	ok_.addActionListener (this);
	cancel_.addActionListener (this);

	return panel;
    }

    /**
     * Implements action listener for two buttons.
     */
    public void actionPerformed (ActionEvent e)
    {
	Object source = null;

	if ((source = e.getSource()) == ok_) {
	    String sel = input_.getText ();
	    sel = sel.trim ();
	    if (sel == null || sel.length() == 0 || 
		sel.equals ("none") == true)
		disp_.startUpdating (null);
	    else
		disp_.startUpdating (sel);
	    hide ();
	}		
	else if (source == cancel_) {
	    parent_.setState (false);
	    hide ();
	}
	else {
	    smsgDialog_.pack ();
	    smsgDialog_.setLocationRelativeTo (disp_.getTable());
	    // I have to use setVisiable instead of show to make sure
	    // dialog box is poped up on top of table widget.
	    smsgDialog_.setVisible (true);
	}   
    }    
}

	








