/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Top level window of Jcmlog java browser
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: Jcmlog.java,v $
 *   Revision 1.1  2001/10/18 18:45:41  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.util.*;
import java.text.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import cmlog.*;

public class Jcmlog extends JFrame implements Runnable
{
    /**
     * Menu bar of this window.
     */
    private JMenuBar menuBar_ = null;

    /**
     * Display of this window.
     */
    private Disp     disp_ = null;

    /**
     * Single Date object keep track current time.
     */
    private static   Date currt_ = null;

    /**
     * Current time from JAN 1, 1970
     */
    private static   long offset_ = 0;
    private static   long loop_ = 0;

    /**
     * Time information display window
     */
    MiscPanel        misc_ = null;

    /**
     * Menu items for file menu.
     */
    Connect conn_ = null;
    Disconnect disc_ = null;
    Exit exit_ = null;


    /**
     * Menu Items for option menu.
     */
    SaveConfig savec_ = null;
    RemoveAll rmall_ = null;
    Query     query_ = null;
    Update update_ = null;

    /**
     * Menu items for help
     */
    About     about_ = null;

    /**
     * Constructor for this top level window
     */
    public Jcmlog (Config config)
    {
	Container contentPane = getContentPane();
	JScrollPane scrollPane;
	JTable      table;
	JMenu       menu;
	
	// set font
	setFont(new Font("Helvetica", Font.PLAIN, 14));

	addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
		    disp_.exit();
		}
	    });
	
	disp_ = new Disp (config, 24, Disp.IDLE);


	// set parent window of this display
	disp_.setParentWindow (this);

	table = disp_.getTable ();

	scrollPane = new JScrollPane(table);
	contentPane.add(scrollPane, BorderLayout.CENTER);

	// set scroll pane
	disp_.setScrollPane (scrollPane);

	// create time window
	misc_ = new MiscPanel (disp_);
	JPanel twPanel = misc_.getPanel ();
	contentPane.add (twPanel, BorderLayout.SOUTH);

	// create menu bar
        menuBar_ = new JMenuBar();
        setJMenuBar (menuBar_);

	// Build the first menu.
        menu = new JMenu("File");
        menu.setMnemonic(KeyEvent.VK_F);
        menuBar_.add(menu);
	
	conn_ = new Connect (disp_, menu);
	disc_ = new Disconnect (disp_, menu);
	menu.addSeparator();
	exit_ = new Exit (disp_, menu);
	

	// Build the Options menu.
        menu = new JMenu("Options");
        menu.setMnemonic(KeyEvent.VK_O);
        menuBar_.add(menu);
	
	savec_ = new SaveConfig (disp_, menu);
	rmall_ = new RemoveAll (disp_, menu);
	query_ = new Query (disp_, menu);
	update_ = new Update (disp_, menu);

	// Push last menu to the right most position
	menuBar_.add(Box.createHorizontalGlue());
	// Build help menu
	menu = new JMenu ("Help");
	menu.setMnemonic(KeyEvent.VK_A);
	menuBar_.add (menu);

	about_ = new About (disp_, menu);

	// initial state is disconnected state
	setDisconnectedState ();
    }

    /**
     * Timer thread
     */
    public void run ()
    {
	while (true) {
	    try {
		Thread.sleep (1000);
	    }catch (Exception e) {
		;
	    }
	
	    if (currt_ == null) {
		currt_ = new Date ();
		offset_ = currt_.getTime ();
	    }
	    else {
		offset_ += 1000;
		loop_ ++;

		if (loop_ >= 600) {// every 10 minutes read from system clock
		    loop_ = 0;
		    currt_ = new Date ();
		    offset_ = currt_.getTime();
		}
		else 
		    currt_.setTime (offset_);
	    }
	    misc_.setCurrentTime (currt_);
	}
    }

    /**
     * Set menu items for disconnected state.
     */
    public void setDisconnectedState ()
    {
	disc_.setEnabled (false);
	conn_.setEnabled (true);
	exit_.setEnabled (true);
	update_.setEnabled (false);
	query_.setEnabled (false);
    }

    /**
     * Set menu items for disconnected state.
     */
    public void setConnectedState ()
    {
	disc_.setEnabled (true);
	conn_.setEnabled (false);
	exit_.setEnabled (false);
	update_.setEnabled (true);
	query_.setEnabled (true);
    }

    /**
     * Set option menu item to reflect type of operation.
     */
    public void setDisplayType (int type)
    {
	if (type == Disp.UPDATING) {
	    if (update_.getState() != true)
		update_.setState (true);
	    update_.setEnabled (true);
	    query_.setEnabled (false);
	}
	else if (type == Disp.QUERYING) {
	    if (update_.getState() != true)
		update_.setState (false);
	    update_.setEnabled (false);
	    query_.setEnabled (false);
	}
	else {
	    update_.setEnabled (true);
	    if (update_.getState() != false)
		update_.setState (false);
	    query_.setEnabled (true);
	}
    }

    /**
     * Set starting time of an action (update/query)
     * @param now time of this action or null to erase display
     *         
     */
    public void setStartTime (Date now)
    {
	misc_.setStartTime (now);
    }

    /**
     * Set end time of an action (update/query)
     * @param now time of this action or null to erase display
     */
    public void setEndTime (Date now)
    {
	misc_.setEndTime (now);
    }
	    


    public static void main(String[] args) 
    {
	boolean status = true;
	Config config = Config.getConfig();

	String cfname = System.getProperty ("user.home") + File.separator + ".jcmlogrc"; 
	
	Thread timer = null;

	try {
	    status = config.parseFile (cfname);
	}catch (Exception e) {
	    System.err.println ("Parsing config file error: " + e.getMessage());
	}
	
        Jcmlog window = new Jcmlog (config);

        window.setTitle(config.getName());
	window.setSize (config.getTotalColumnWidth() + 20, 300);
        window.setVisible(true);

	// create a timer thread
	timer = new Thread (window);
	timer.start ();
    }

    /**
     * Enable the stop button
     */
    public void enableStopButton ()
    {
	misc_.enableStopButton ();
    }

    /**
     * Disable the stop button
     */
    public void disableStopButton ()
    {
	misc_.disableStopButton ();
    }
}








