/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Connect menu button inside File Menu
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: Disconnect.java,v $
 *   Revision 1.1  2001/10/18 18:45:41  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import cmlog.*;

public class Disconnect extends JMenuItem implements ActionListener
{
    /**
     * Reference to display object.
     */
    private Disp disp_;

    /**
     * Constructor
     */
    public Disconnect (Disp disp, JMenu menu)
    {
	super ("Disconnect", KeyEvent.VK_D);
	
	disp_ = disp;

	addActionListener (this);

	menu.add (this);
    }

    /**
     * Implmentation of actionPerformed when exit button is pressed.
     */
    public void actionPerformed(ActionEvent e) 
    {
	int option;
	option = JOptionPane.showConfirmDialog (disp_.getParentWindow(),
						"Disconnect from the cmlog server, Are you sure?", "disconnect dialog", 
						JOptionPane.YES_NO_OPTION);
	if (option == JOptionPane.YES_OPTION)
	    disp_.disconnect ();
    }
}









