/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Connect Dialog Box for connect menu entry
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: ConnectDialog.java,v $
 *   Revision 1.2  2001/10/19 18:16:11  chen
 *   Change how image is loaded
 *
 *   Revision 1.1  2001/10/18 18:45:41  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import cmlog.*;

public class ConnectDialog extends JDialog implements ActionListener
{
    /**
     * Internal ok button.
     */
    private JButton ok_;

    /**
     * Internal cancel button.
     */
    private JButton cancel_;

    /**
     * Check box for protocol version 2
     */
    private JCheckBox version_;

    /**
     * Internal combo-box for server selection.
     */
    private JComboBox servers_;

    /**
     * Internal combo-box for port selection.
     */    
    private JComboBox ports_;

    /**
     * Display associated with this dialog.
     */
    private Disp disp_;


    /**
     * Constructor.
     */
    public ConnectDialog (Disp disp, JMenuItem item)
    {
	super (disp.getParentWindow(),
	       "CMLOG Server Selection", true);
	
	disp_ = disp;

	JPanel manager = new JPanel ();
	manager.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
	manager.setLayout(new BorderLayout(10, 10));
	
	// create a Label
	Font defont = getFont();
	Font newfont = defont.deriveFont (Font.BOLD);
	JLabel title = new JLabel ("Select cmlog server host and port ");

	title.setFont (newfont);
	manager.add(title, BorderLayout.NORTH);

	// create combo boxes for server and ports
	JPanel combopanel = createComboBoxes ();
	manager.add(combopanel, BorderLayout.CENTER);

	// create button panels
	JPanel buttonpanel = createButtons ();
	manager.add(buttonpanel, BorderLayout.SOUTH);

	// put panel into content pane
	Container cpn = getContentPane ();
	cpn.add (manager);

	getRootPane().setDefaultButton(ok_);
	
    }


    /**
     * Create comboxes.
     */
    private JPanel createComboBoxes ()
    {
	GridBagLayout bl = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	JPanel panel = new JPanel (bl);


	// create label for server
	JLabel slabel = new JLabel ("Server Host:");
	c.fill = GridBagConstraints.BOTH;
        c.gridx = 0;
        c.gridy = 0;
	c.ipadx = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0;
        c.weighty = 0;
	
	panel.add (slabel);
	bl.setConstraints (slabel, c);

	// create server combo box
	Config cobj = disp_.getConfigObject ();
	if (cobj.getServerNames () != null)
	    servers_ = new JComboBox (cobj.getServerNames ());
	else
	    servers_ = new JComboBox ();
	servers_.setEditable (true);

	c.fill = GridBagConstraints.BOTH;
        c.gridx = 1;
        c.gridy = 0;
	c.ipadx = 4;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1;
        c.weighty = 0;
	
	panel.add (servers_);
	bl.setConstraints (servers_, c);

	// create port label
	JLabel plabel = new JLabel ("Server Port:");
	c.fill = GridBagConstraints.BOTH;
        c.gridx = 3;
        c.gridy = 0;
	c.ipadx = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0;
        c.weighty = 0;
	
	panel.add (plabel);
	bl.setConstraints (plabel, c);

	
	// create ports combo box
	int[]     ports = cobj.getPortNumbers ();
	String[]  portns = null;
	if (ports != null) {
	    portns = new String[ports.length];
	    for (int i = 0; i < ports.length; i++)
		portns[i] = String.valueOf(ports[i]);
	}
	if (portns != null)
	    ports_ = new JComboBox (portns);
	else
	    ports_ = new JComboBox ();

	ports_.setEditable (true);

	c.fill = GridBagConstraints.BOTH;
        c.gridx = 4;
        c.gridy = 0;
	c.ipadx = 4;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1;
        c.weighty = 0;
	
	panel.add (ports_);
	bl.setConstraints (ports_, c);

	// create check box
	if (cobj.getProtocolVersion() == 2)
	    version_ = new JCheckBox ("Protocol Version 2.x", true);
	else
	    version_ = new JCheckBox ("Protocol Version 2.x", false);
	c.fill = GridBagConstraints.BOTH;
        c.gridx = 0;
        c.gridy = 1;
	c.ipadx = 4;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1;
        c.weighty = 0;
	
	panel.add (version_);
	bl.setConstraints (version_, c);	

	return panel;
    }	


    /**
     * Create button panels
     */
    private JPanel createButtons ()
    {
	GridBagLayout bl = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	JPanel panel = new JPanel (bl);

	// create ok button
	ok_ = new JButton ("Ok");
	c.fill = GridBagConstraints.BOTH;
        c.gridx = 0;
        c.gridy = 0;
	c.insets = new Insets (0, 0, 0, 20);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0;
        c.weighty = 0;
	
	panel.add (ok_);
	bl.setConstraints (ok_, c);

	// create cancel button 
	cancel_ = new JButton ("Cancel");
	c.fill = GridBagConstraints.BOTH;
        c.gridx = 1;
        c.gridy = 0;
	c.insets = new Insets (0, 20, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0;
        c.weighty = 0;
	
	panel.add (cancel_);
	bl.setConstraints (cancel_, c);

	// add action listener
	ok_.addActionListener (this);
	cancel_.addActionListener (this);

	return panel;
    }  

    /**
     * Implements action listener for two buttons.
     */
    public void actionPerformed (ActionEvent e)
    {
	if (e.getSource() == ok_) {
	    String  server = (String)servers_.getSelectedItem();
	    String  iport  = (String)ports_.getSelectedItem();

	    if (server == null) {
		disp_.popupErrorDialog ("No cmlog server host provided.");
		return;
	    }
	    if (iport == null) {
		disp_.popupErrorDialog ("No cmlog server port provided.");
		return;
	    }

	    Config cobj = disp_.getConfigObject ();	    
	    cobj.addServer (server);
	    cobj.addPort   (Integer.valueOf(iport).intValue());
	    
	    if (version_.isSelected())
		// version 2
		cmlog.Config.PROTOCOL_MAJOR_VERSION = 2;
	    else
		cmlog.Config.PROTOCOL_MAJOR_VERSION = 1;

	    disp_.connect (server, Integer.valueOf(iport).intValue());
	}
	hide ();
    }

}





