/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Arrow Icon for Arrow Button
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: ArrowIcon.java,v $
 *   Revision 1.1  2001/10/18 18:45:40  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.awt.*;
import javax.swing.*;

public class ArrowIcon implements Icon, SwingConstants {
    private int width_;
    private int height_;

    private int[] xPoints = new int[3];
    private int[] yPoints = new int[3];

    /**
     * Constructor
     *
     * @param width icon width.
     * @param height icon height.
     * @param direction icon direction: LEFT, RIGHT, TOP, BOTTOM
     */
    public ArrowIcon(int width, int height, int direction) 
    {
	width_ = width;
	height_ = height;
	if (direction == LEFT) {
            xPoints[0] = width;
            yPoints[0] = 0;
            xPoints[1] = width;
            yPoints[1] = height;
            xPoints[2] = 0;
            yPoints[2] = height/2;
        }
	else if (direction == RIGHT) {
            xPoints[0] = 0;
            yPoints[0] = 0;
            xPoints[1] = 0;
            yPoints[1] = height;
            xPoints[2] = width;
            yPoints[2] = height/2;
        }
	else if (direction == TOP) {
            xPoints[0] = width/2;
            yPoints[0] = 0;
            xPoints[1] = width;
            yPoints[1] = height;
            xPoints[2] = 0;
            yPoints[2] = height;
	}
	else { // direction to bottom
            xPoints[0] = 0;
            yPoints[0] = 0;
            xPoints[1] = width;
            yPoints[1] = 0;
            xPoints[2] = width/2;
            yPoints[2] = height;
	}
	
    }

    public int getIconHeight() {
        return height_;
    }

    public int getIconWidth() {
        return width_;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int length = xPoints.length;
        int adjustedXPoints[] = new int[length];
        int adjustedYPoints[] = new int[length];

        for (int i = 0; i < length; i++) {
            adjustedXPoints[i] = xPoints[i] + x;
            adjustedYPoints[i] = yPoints[i] + y;
        }

        if (c.isEnabled()) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.gray);
        }

        g.fillPolygon(adjustedXPoints, adjustedYPoints, length);
    }
}








