/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Help about dialog box
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: AboutDialog.java,v $
 *   Revision 1.2  2001/10/19 18:16:11  chen
 *   Change how image is loaded
 *
 *   Revision 1.1  2001/10/18 18:45:40  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

public class AboutDialog extends JDialog
{
    /**
     * Text String to display information.
     */
    private static final String[] about_ = {"Java-based CMLOG Viewer",
					    "Developed at Jefferson Lab, by High Performance Computing Group",
					    "Developed at SLAC, with Software Control Group"};


    /**
     * Constructor.
     */
    public AboutDialog (Disp disp)
    {
	super (disp.getParentWindow(),
	       "CMLOG Version", false);

	JPanel manager = new JPanel ();
	manager.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
	manager.setLayout(new BorderLayout());
	
	// create icon on the left
	byte[] img = Util.imageByte (Util.logbytes);
	ImageIcon icon = null;
	if (img != null)
	    icon = new ImageIcon (img);
	JLabel iconlabel = new JLabel (icon);
	manager.add (iconlabel, BorderLayout.WEST);

	// create list of label on the right
	JPanel rpanel = new JPanel (new GridLayout (3, 1, 0, 20));
	
	for (int i = 0; i < about_.length; i++) {
	    JLabel label = new JLabel (about_[i]);
	    label.setHorizontalAlignment (SwingConstants.CENTER);
	    rpanel.add (label);
	}
	manager.add (rpanel, BorderLayout.EAST);

	// put panel into content pane
	Container cpn = getContentPane ();
	cpn.add (manager);
    }
}






