//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Return Java Virtual Machine Pid Number
//      This class may be machine dependent
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: Pid.java,v $
//   Revision 1.1  2000/03/17 19:18:37  chen
//   add java client
//
//
//
package cmlog;

import java.io.*;

public class Pid
{
    public static int getpid () throws IOException
    {
	int pid = 0;
	String pidstr;
	Process p = null;
	BufferedReader pin = null;

	Runtime r = Runtime.getRuntime();
	try {
	     p = r.exec ("cmlogParentPid");
	}catch (IOException e) {
	    throw e;
	}catch (SecurityException se) {
	    throw new IOException ("Security violation");
	}
	
	// get output from cmlogParentPid
	pin = new BufferedReader(new InputStreamReader(p.getInputStream()));
	// read output
	try {
	    pidstr = pin.readLine();
	}catch (IOException e) {
	    System.err.println ("parentpid output no result");
	    throw e;
	}

	pid = Integer.valueOf(pidstr).intValue();
	return pid;
    }
}


	

	
	
