//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Configuration and Protocol Information
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: Config.java,v $
//   Revision 1.3  2000/03/17 19:18:37  chen
//   add java client
//
//   Revision 1.2  2000/02/07 20:06:09  chen
//   add protocol version 2
//
//   Revision 1.1  2000/01/04 14:26:10  chen
//   new implementation
//
//
//
package cmlog;

public final class Config
{
    public static boolean debug = false;

    /**
     * Port numbers for cmlog systems
     * Modify them to fit into your system
     */
    public static int     CMLOG_PORT = 8900;
    public static int     CMLOG_CLNT_PORT= 8909;
    public static String  CMLOG_CLNT_PIPE = "/tmp/cmlog/";
    public static String  CMLOG_CLNT_PIPE_PREFIX = "cmlog_";

    /* The following are the same as CDEV error code */
    public static final int CMLOG_SUCCESS = 0;
    public static final int CMLOG_ERROR   = -1;
    public static final int CMLOG_INVALIDOBJ = 1;
    /* invalid cdev objects                     */
    public static final int CMLOG_INVALIDARG = 2;
    /* invalid argument passed to cdev calls    */
    public static final int CMLOG_INVALIDSVC = 3;
    /* wrong service during dynamic loading     */
    public static final int CMLOG_NOTCONNECTED = 4;
    /* not connected to low network service     */
    public static final int CMLOG_IOFAILED = 5;
    /* low level network service IO failed      */
    public static final int CMLOG_CONFLICT = 6;
    /* conflicts of data types or tags          */
    public static final int CMLOG_NOTFOUND = 7;
    /* cdev cannot find user request (cdevData) */
    public static final int CMLOG_TIMEOUT = 8;
    /* time out                                 */
    public static final int CMLOG_CONVERT = 9;
    /* cdevData conversion error                */
    public static final int CMLOG_OUTOFRANGE = 10;
    /* value out of range for device attribute  */
    public static final int CMLOG_NOACCESS = 11 ;
    /* insufficient access to perform request   */
    public static final int CMLOG_ACCESSCHANGED = 12;
    /* change in access permission of device    */
    public static final int CMLOG_DISCONNECTED = 60;
    /* channel has been disconnected            */
    public static final int CMLOG_RECONNECTED = 61;
    /* channel has been reconnected             */

    /* The following are unique to the CMLOG    */
    public static final int CMLOG_NOTCONSERVER = 80;
    /* can not connect to server/ not connected  */
    public static final int CMLOG_NOTFOUNDSERVER = 81;
    /* can not find server                       */
    public static final int CMLOG_CONN_TIMEOUT = 82;
    /* connection timeout                        */
    public static final int CMLOG_FILTERED = 83;
    /* messages have been filtered               */
    public static final int CMLOG_NOFILTERING = 84;
    /* no filtering applied                      */
    public static final int CMLOG_DROPPED = 85;
    /* message is dropped                        */
    public static final int CMLOG_BADIO = 86;
    /* TCP io is bad file descriptor             */
    public static final int CMLOG_OVERFLOW = 87;
    /* query message overflow buffer             */
    public static final int CMLOG_INCOMPLETE = 88;
    /* data flow will coming (unfinished)        */
    public static final int CMLOG_CBK_FINISHED = 89;
    /* callback finished (monitor off)           */
    public static final int CMLOG_PAUSED = 90;
    /* query callback is paused                  */
    public static final int CMLOG_QUERYMSG_ERR = 91;
    /* query message syntax error                */
    public static final int CMLOG_THREAD_ERR = 92;
    /* query thread init error                   */
    public static final int CMLOG_QUERY_CANCELED = 93;
    /* query service is canceled                 */

    public static final int CMLOG_IOERROR = CMLOG_IOFAILED;
    public static final int CMLOG_INVALID = CMLOG_INVALIDARG;

    /**
     * Protocol version number 
     * It can be either 1 or 2
     */
    public static int PROTOCOL_MAJOR_VERSION = 2;
    public static int PROTOCOL_MINOR_VERSION = 0;

    /**
     * CMLOG protocol version 
     */
    public static int PROTOCOL_VERSION ()
    {
	return (1000*PROTOCOL_MAJOR_VERSION + PROTOCOL_MINOR_VERSION);
    }

    /**
     * Protocol version string
     */
    public static String PROTOCOL_VERSION_STRING ()
    {
	if (Config.PROTOCOL_MAJOR_VERSION >= 2)
	    return "cmlog protocol version 2.x";
	else
	    return "cmlog protocol version 1.x";
    }

    /* magic number for packet */
    public static final int    CMLOG_PMAGIC = 0xcde50052;
    /* magic number for msg    */
    public static final int    CMLOG_MAGIC  = 0x000000a2;

    /* The following commands are for cmlog server only                     */
    public static final int CMLOG_UNKNOWN =0;
    /* unknown/init operation      */
    public static final int CMLOG_EMPTY =1;
    /* empty message/ junk         */

    public static final int CMLOG_CLNTLKSVC = 3000;
    /* client looking for server */
    public static final int CMLOG_BRSERLKSVC= 3001;
    /* Browser looking for server*/
    public static final int CMLOG_ADMINLKSVC = 3002;
    /* admin looking for server  */
    public static final int CMLOG_SERVERALIVE = 3003;
    /* Server is alive and well  */
    public static final int CMLOG_USERLKCLNT = 3004;
    /* user task look clnt daemon*/
    public static final int CMLOG_TAGMAP = 3005; 
    /* Clnt sends tag map table  */
    public static final int CMLOG_CONN_INFO = 3006;
    /* logging connection info   */
    public static final int CMLOG_CLOSE_CONN = 3007;
    /* logging process quit      */
    public static final int CMLOG_CHANGE_SRP = 3008;
    /* change srv port to clnd   */
    public static final int CMLOG_ADD_DATA = 3100;
    /* add new data to database  */
    public static final int CMLOG_FIND_DATA = 3101;
    /* find data in the database */
    public static final int CMLOG_ADD_CXT = 3102;
    /* insert client context     */
    public static final int CMLOG_CHANGE_TAGS = 3103;
    /* change tag map            */
    public static final int CMLOG_FLUSH = 3104;
    /* flush network buffer      */
    public static final int CMLOG_ISR_DATA = 3105;
    /* ISR from vx needs process */
    public static final int CMLOG_GET_OPENFD = 3106;
    /* get opend fd from a proc  */
    public static final int CMLOG_GET_ATTR =3107;
    /* get server attributes     */
    public static final int CMLOG_RECONN_INFO = 3108;
    /* reconnection info         */

    public static final int CMLOG_EXIT = 4000;
    /* internal  use only        */
    public static final int CMLOG_DBASE  =4001;
    /* internal  use only        */


    /* All tags                  */
    private static String KEY_TAG_STR = "cmlogTime";
    private static String STR_TAG_STR = "cmlogString";
    private static String CLNTCXT_TAG_STR = "cmlogClntCxt";
    private static String HOST_TAG_STR = "host";
    private static String PID_TAG_STR = "pid";
    private static String NAME_TAG_STR = "name";
    private static String CLASS_TAG_STR = "class";
    private static String DOMAIN_TAG_STR ="domain";
    private static String FACILITY_TAG_STR = "facility";
    private static String CODE_TAG_STR = "code";
    private static String VERBOSITY_TAG_STR = "verbosity";
    private static String SEVERITY_TAG_STR = "severity";
    private static String USER_TAG_STR = "user";
    private static String TEXT_TAG_STR = "text";
    private static String STATUS_TAG_STR ="status";
    private static String VALUE_TAG_STR = "value";
    private static String RESULT_TAG_STR = "resultCode";
    private static String INCOMPLETE_TAG_STR = "incomplete";
    private static String CLNTID_TAG_STR = "cmlogClntId";
    private static String DISP_TAG_STR = "cmlogDispName";
    private static String DROPPED_TAG_STR = "dropped";
    private static String START_TAG_STR = "start";
    private static String END_TAG_STR = "end";
    private static String PROC_TAG_STR = "process";
    private static String NUMITEMS_TAG_STR = "numberItems";
    private static String QUERYMSG_TAG_STR = "queryMsg";
    private static String LINE_TAG_STR = "line";
    
    /* All integer tags           */
    public  static int KEY_TAG        = 1234;
    public  static int STR_TAG        = 1235;
    public  static int CLNTCXT_TAG    = 1236;
    public  static int HOST_TAG       = 1237;
    public  static int PID_TAG        = 1238;
    public  static int NAME_TAG       = 1239;
    public  static int CLASS_TAG      = 1240;
    public  static int DOMAIN_TAG     = 1241;
    public  static int FACILITY_TAG   = 1242;
    public  static int CODE_TAG       = 1243;
    public  static int VERBOSITY_TAG  = 1244;
    public  static int SEVERITY_TAG   = 1245;
    public  static int USER_TAG       = 1246;
    public  static int CLNTID_TAG     = 1247;
    public  static int DISP_TAG       = 1248;
    public  static int DROPPED_TAG    = 1249;
    public  static int START_TAG      = 1250;
    public  static int END_TAG        = 1251;
    public  static int TEXT_TAG       = 1252;
    public  static int STATUS_TAG     = 1253;
    public  static int INCOMPLETE_TAG = 1254;
    public  static int RESULT_TAG     = 1255;
    public  static int VALUE_TAG      = 1256;
    public  static int PROC_TAG       = 1257;
    public  static int NUMITEMS_TAG   = 1258;
    public  static int QUERYMSG_TAG   = 1259;
    public  static int LINE_TAG       = 1260;


    public static boolean tagInserted  = false;

    /**
     * Set up all tags 
     */
    public synchronized static void setupTags ()
    {
	if (Config.tagInserted == true)
	    return;

	cdevTagTable tbl = cdevTagTable.tagTable();

	if (tbl.tagExists (Config.KEY_TAG_STR) == true)
	    Config.KEY_TAG = tbl.convertKey (Config.KEY_TAG_STR);
	else
	    tbl.insert (Config.KEY_TAG, Config.KEY_TAG_STR);

	if (tbl.tagExists (Config.STR_TAG_STR) == true)
	    Config.STR_TAG = tbl.convertKey (Config.STR_TAG_STR);
	else
	    tbl.insert (Config.STR_TAG, Config.STR_TAG_STR);	

	if (tbl.tagExists (Config.CLNTCXT_TAG_STR) == true)
	    Config.CLNTCXT_TAG =tbl.convertKey(Config.CLNTCXT_TAG_STR);
	else
	    tbl.insert (Config.CLNTCXT_TAG, Config.CLNTCXT_TAG_STR);

	if (tbl.tagExists (Config.HOST_TAG_STR) == true)
	    Config.HOST_TAG = tbl.convertKey (Config.HOST_TAG_STR);
	else
	    tbl.insert (Config.HOST_TAG, Config.HOST_TAG_STR);

	if (tbl.tagExists (Config.PID_TAG_STR) == true)
	    Config.PID_TAG = tbl.convertKey (Config.PID_TAG_STR);
	else
	    tbl.insert (Config.PID_TAG, Config.PID_TAG_STR);

	if (tbl.tagExists (Config.NAME_TAG_STR) == true)
	    Config.NAME_TAG = tbl.convertKey (Config.NAME_TAG_STR);
	else
	    tbl.insert (Config.NAME_TAG, Config.NAME_TAG_STR);

	if (tbl.tagExists (Config.CLASS_TAG_STR) == true)
	    Config.CLASS_TAG = tbl.convertKey (Config.CLASS_TAG_STR);
	else
	    tbl.insert (Config.CLASS_TAG, Config.CLASS_TAG_STR);

	if (tbl.tagExists (Config.DOMAIN_TAG_STR) == true)
	    Config.DOMAIN_TAG = tbl.convertKey (Config.DOMAIN_TAG_STR);
	else
	    tbl.insert (Config.DOMAIN_TAG, Config.DOMAIN_TAG_STR);

	if (tbl.tagExists (Config.FACILITY_TAG_STR) == true)
	    Config.FACILITY_TAG = tbl.convertKey (Config.FACILITY_TAG_STR);
	else
	    tbl.insert (Config.FACILITY_TAG, Config.FACILITY_TAG_STR);

	if (tbl.tagExists (Config.CODE_TAG_STR) == true)
	    Config.CODE_TAG = tbl.convertKey (Config.CODE_TAG_STR);
	else
	    tbl.insert (Config.CODE_TAG, Config.CODE_TAG_STR);

	if (tbl.tagExists (Config.VERBOSITY_TAG_STR) == true)
	    Config.VERBOSITY_TAG = tbl.convertKey (Config.VERBOSITY_TAG_STR);
	else
	    tbl.insert (Config.VERBOSITY_TAG, Config.VERBOSITY_TAG_STR);

	if (tbl.tagExists (Config.SEVERITY_TAG_STR) == true)
	    Config.SEVERITY_TAG = tbl.convertKey (Config.SEVERITY_TAG_STR);
	else
	    tbl.insert (Config.SEVERITY_TAG, Config.SEVERITY_TAG_STR);

	if (tbl.tagExists (Config.USER_TAG_STR) == true)
	    Config.USER_TAG = tbl.convertKey (Config.USER_TAG_STR);
	else
	    tbl.insert (Config.USER_TAG, Config.USER_TAG_STR);

	if (tbl.tagExists (Config.CLNTID_TAG_STR) == true)
	    Config.CLNTID_TAG = tbl.convertKey (Config.CLNTID_TAG_STR);
	else
	    tbl.insert (Config.CLNTID_TAG, Config.CLNTID_TAG_STR);


	if (tbl.tagExists (Config.DISP_TAG_STR) == true)
	    Config.DISP_TAG = tbl.convertKey (Config.DISP_TAG_STR);
	else
	    tbl.insert (Config.DISP_TAG, Config.DISP_TAG_STR);

	if (tbl.tagExists (Config.DROPPED_TAG_STR) == true)
	    Config.DROPPED_TAG = tbl.convertKey (Config.DROPPED_TAG_STR);
	else
	    tbl.insert (Config.DROPPED_TAG, Config.DROPPED_TAG_STR);

	if (tbl.tagExists (Config.START_TAG_STR) == true)
	    Config.START_TAG = tbl.convertKey (Config.START_TAG_STR);
	else
	    tbl.insert (Config.START_TAG, Config.START_TAG_STR);

	if (tbl.tagExists (Config.END_TAG_STR) == true)
	    Config.END_TAG = tbl.convertKey (Config.END_TAG_STR);
	else
	    tbl.insert (Config.END_TAG, Config.END_TAG_STR);

	if (tbl.tagExists (Config.TEXT_TAG_STR) == true)
	    Config.TEXT_TAG = tbl.convertKey (Config.TEXT_TAG_STR);
	else
	    tbl.insert (Config.TEXT_TAG, Config.TEXT_TAG_STR);


	if (tbl.tagExists (Config.STATUS_TAG_STR) == true)
	    Config.STATUS_TAG = tbl.convertKey (Config.STATUS_TAG_STR);
	else
	    tbl.insert (Config.STATUS_TAG, Config.STATUS_TAG_STR);

	if (tbl.tagExists (Config.INCOMPLETE_TAG_STR) == true)
	    Config.INCOMPLETE_TAG = tbl.convertKey (Config.INCOMPLETE_TAG_STR);
	else
	    tbl.insert (Config.INCOMPLETE_TAG, Config.INCOMPLETE_TAG_STR);

	if (tbl.tagExists (Config.RESULT_TAG_STR) == true)
	    Config.RESULT_TAG = tbl.convertKey (Config.RESULT_TAG_STR);
	else
	    tbl.insert (Config.RESULT_TAG, Config.RESULT_TAG_STR);

	if (tbl.tagExists (Config.VALUE_TAG_STR) == true)
	    Config.VALUE_TAG = tbl.convertKey (Config.VALUE_TAG_STR);
	else
	    tbl.insert (Config.VALUE_TAG, Config.VALUE_TAG_STR);

	if (tbl.tagExists (Config.PROC_TAG_STR) == true)
	    Config.PROC_TAG = tbl.convertKey (Config.PROC_TAG_STR);
	else
	    tbl.insert (Config.PROC_TAG, Config.PROC_TAG_STR);

	if (tbl.tagExists (Config.NUMITEMS_TAG_STR) == true)
	    Config.NUMITEMS_TAG = tbl.convertKey (Config.NUMITEMS_TAG_STR);
	else
	    tbl.insert (Config.NUMITEMS_TAG, Config.NUMITEMS_TAG_STR);

	if (tbl.tagExists (Config.QUERYMSG_TAG_STR) == true)
	    Config.QUERYMSG_TAG = tbl.convertKey (Config.QUERYMSG_TAG_STR);
	else
	    tbl.insert (Config.QUERYMSG_TAG, Config.QUERYMSG_TAG_STR);

	if (tbl.tagExists (Config.LINE_TAG_STR) == true)
	    Config.LINE_TAG = tbl.convertKey (Config.LINE_TAG_STR);
	else
	    tbl.insert (Config.LINE_TAG, Config.LINE_TAG_STR);

	Config.tagInserted = true;

	if (Config.debug == true) {
	    int[] itag = new int[1000];
	    String[] stag = new String[1000];
	    int num = 0;

	    num = tbl.readTagTable (itag, stag, 1000);
	    System.out.println ("Tag Table Contains :");
	    for (int i = 0; i < num; i++) {
		System.out.println ("String Tag: " +  stag[i] + " <======> Int Tag: " + String.valueOf (itag[i]));
	    }
	}
    }


	
}


