//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      cdev data package test
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cdevDataTest.java,v $
//   Revision 1.2  2001/10/18 18:49:57  chen
//   64 bit test
//
//   Revision 1.1  1999/12/14 15:31:36  chen
//   initial java implementation
//
//   Revision 1.1  1999/10/18 17:12:41  chen
//   *** empty log message ***
//
//
//
//
import java.io.*;
import cmlog.*;

public class cdevDataTest
{
    public static final byte bdata = 1;
    public static final short sdata = 2;
    public static final int  idata = 3;
    public static final long ldata = 4;
    public static final float fdata = (float)5.0;
    public static final double ddata = 6.0;
    public static final String strdata = new String ("Hello World I am Here");
    public static final String file = new String ("/home/chen/CMLOG/java/test.dat");
    public static final String coutputfile = new String ("/home/chen/CMLOG/java/coutput.dat");
    public static final String cinputfile = new String ("/home/chen/CMLOG/java/cinput.dat");

    static public void integerConvTest ()
    {

	// test array insert
	int []iarray = new int[127];
	for (int i = 0; i < 127; i++)
	    iarray[i] = i;

	cdevData data = new cdevData ();
	data.insert ("value", iarray);

	// get data test
	cdevDataEntry de = data.get ("value");

	// byte converstion
	byte[] ba = de.byteArray ();
	cdevData data1 = new cdevData ();
	data1.insert ("value", ba);
	
	de = data1.get ("value");
	int []ia = de.intArray();
	cdevData data2 = new cdevData();
	data2.insert ("value", ia);
	if (data.equals (data2))
	    System.out.print ("Integer -> Byte -> Integer OK\n");
	else
	    System.out.print ("Integer -> Byte -> Integer Failed\n");

	// short conversion
	de = data.get ("value");
	short[] sa = de.shortArray ();
	cdevData data3 = new cdevData ();
	data3.insert ("value", sa);
	de = data3.get ("value");
	ia = de.intArray ();

	cdevData data4 = new cdevData();
	data4.insert ("value", ia);
	
	if (data.equals (data4))
	    System.out.print ("Integer -> Short -> Integer OK\n");
	else
	    System.out.print ("Integer -> Short -> Integer Failed\n");


	// long conversion
	de = data.get ("value");
	long[] la = de.longArray ();
	cdevData data5 = new cdevData ();
	data5.insert ("value", la);
	de = data5.get ("value");
	ia = de.intArray ();

	cdevData data6 = new cdevData();
	data6.insert ("value", ia);
	
	if (data.equals (data6))
	    System.out.print ("Integer -> Long -> Integer OK\n");
	else
	    System.out.print ("Integer -> Long -> Integer Failed\n");


	// float conversion
	de = data.get ("value");
	float[] fa = de.floatArray ();
	cdevData data7 = new cdevData ();
	data7.insert ("value", fa);
	de = data7.get ("value");
	ia = de.intArray ();

	cdevData data8 = new cdevData();
	data8.insert ("value", ia);
	
	if (data.equals (data8))
	    System.out.print ("Integer -> Float -> Integer OK\n");
	else
	    System.out.print ("Integer -> Float -> Integer Failed\n");

	// Double conversion
	de = data.get ("value");
	double[] da = de.doubleArray ();
	cdevData data9 = new cdevData ();
	data9.insert ("value", da);
	de = data9.get ("value");
	ia = de.intArray ();

	cdevData data10 = new cdevData();
	data10.insert ("value", ia);
	
	if (data.equals (data10))
	    System.out.print ("Integer -> Double -> Integer OK\n");
	else
	    System.out.print ("Integer -> Double -> Integer Failed\n");
    }

    static public void floatConvTest ()
    {

	// test array insert
	float []farray = new float[127];
	for (int i = 0; i < 127; i++)
	    farray[i] = (float)i;

	cdevData data = new cdevData ();
	data.insert ("value", farray);

	// get data test
	cdevDataEntry de = data.get ("value");

	// byte converstion
	byte[] ba = de.byteArray ();
	cdevData data1 = new cdevData ();
	data1.insert ("value", ba);
	
	de = data1.get ("value");
	float []ia = de.floatArray();
	cdevData data2 = new cdevData();
	data2.insert ("value", ia);
	if (data.equals (data2))
	    System.out.print ("Float -> Byte -> Float OK\n");
	else
	    System.out.print ("Float -> Byte -> Float Failed\n");

	// short conversion
	de = data.get ("value");
	short[] sa = de.shortArray ();
	cdevData data3 = new cdevData ();
	data3.insert ("value", sa);
	de = data3.get ("value");
	ia = de.floatArray ();

	cdevData data4 = new cdevData();
	data4.insert ("value", ia);
	
	if (data.equals (data4))
	    System.out.print ("Float -> Short -> Float OK\n");
	else
	    System.out.print ("Float -> Short -> Float Failed\n");


	// long conversion
	de = data.get ("value");
	long[] la = de.longArray ();
	cdevData data5 = new cdevData ();
	data5.insert ("value", la);
	de = data5.get ("value");
	ia = de.floatArray ();

	cdevData data6 = new cdevData();
	data6.insert ("value", ia);
	
	if (data.equals (data6))
	    System.out.print ("Float -> Long -> Float OK\n");
	else
	    System.out.print ("Float -> Long -> Float Failed\n");


	// Integer conversion
	de = data.get ("value");
	int[] fa = de.intArray ();
	cdevData data7 = new cdevData ();
	data7.insert ("value", fa);
	de = data7.get ("value");
	ia = de.floatArray ();

	cdevData data8 = new cdevData();
	data8.insert ("value", ia);
	
	if (data.equals (data8))
	    System.out.print ("Float -> Integer -> Float OK\n");
	else
	    System.out.print ("Float -> Integer -> Float Failed\n");

	// Double conversion
	de = data.get ("value");
	double[] da = de.doubleArray ();
	cdevData data9 = new cdevData ();
	data9.insert ("value", da);
	de = data9.get ("value");
	ia = de.floatArray ();

	cdevData data10 = new cdevData();
	data10.insert ("value", ia);
	
	if (data.equals (data10))
	    System.out.print ("Float -> Double -> Float OK\n");
	else
	    System.out.print ("Float -> Double -> Float Failed\n");
    }

    public static cdevData arrayData ()
    {
	cdevData data = new cdevData ();
	int i;

	// insert array of double 
	double[] darray = new double[127];
	for (i = 0; i < 127; i++)
	    darray[i] = 123.232 + i*121.121 + i/89.12;
	data.insert ("value0", darray);

	// insert array of string
	String[] sarray = new String[211];
	for (i = 0; i < 211; i++) 
	    sarray[i] = new String("value plus " + String.valueOf(i));
	data.insert ("value1", sarray);

	return data;
    }


    public static void main (String[] args)
    {
	cdevData.insertTag (1000, "value0");
	cdevData.insertTag (1001, "value1");
	cdevData.insertTag (1002, "value2");
	cdevData.insertTag (1003, "value3");
	cdevData.insertTag (1004, "value4");
	cdevData.insertTag (1005, "value5");
	cdevData.insertTag (1006, "value6");
	cdevData.insertTag (1012, "value12");
	cdevData.insertTag (1021, "value21");

	cdevData data = new cdevData();

	// test scaler data insert
	data.insert ("value0", bdata);
	data.insert ("value1", sdata);
	data.insert ("value2", idata);
	data.insert ("value3", ldata);
	data.insert ("value4", fdata);
	data.insert ("value5", ddata);
	data.insert ("value6", strdata);

	try {
	    data.dup ("value4", "value3");
	}catch (IllegalArgumentException e) {
	    data.remove ("value3");
	    data.dup ("value4", "value3");
	}

	data.asciiDump ();

	cdevData data1 = new cdevData (data);
	if (data.equals (data1)) 
	    System.out.print ("Data == Data1\n");
	else
	    System.out.print ("Data != Data1\n");


	data1.insert ("value0", (byte)12);
	if (data.equals (data1)) 
	    System.out.print ("Data == Data1\n");
	else
	    System.out.print ("Data != Data1\n");


	data1.changeTag ("value2", "value12");

	data1.asciiDump ();

	cdevTimeStamp ts = new cdevTimeStamp();
	data1.insert ("value1", ts);
	data1.asciiDump ();

	integerConvTest ();

	floatConvTest();

	// test stream out and stream in
	File outputfile = new File (cdevDataTest.file);
	FileOutputStream output = null;
	try {
	    output = new FileOutputStream (outputfile);
	}catch (IOException e) {
	    System.out.println (e);
	    System.exit (-1);
	}
	
	// find out how big stream cdevData will be
	//	cdevData olddata = arrayData ();
	cdevData olddata = new cdevData ();
	olddata.insert ("value0", (double)129.01);
	olddata.insert ("value1", (double)142323.01);
	olddata.insert ("value3", (long)323232);
	int dsize = olddata.streamSize ();

	System.out.print ("Data size is " + String.valueOf(dsize) + "\n");

	// Create Buffered output stream
	BufferedOutputStream boutput = new BufferedOutputStream (output, dsize);
	try {
	    olddata.streamOut (boutput);
	}catch (IOException e) {
	    System.out.println (e);
	    System.exit (-1);
	}

	try {
	    boutput.flush();
	}catch (IOException e) {
	    System.out.println (e);
	    System.exit (-1);
	}
	

	// create a buffered input stream
	cdevData newdata = new cdevData ();
	FileInputStream input = null;
	try {
	    input = new FileInputStream (outputfile);
	}catch (IOException e) {
	    System.out.println (e);
	    System.exit (-1);
	}
	BufferedInputStream binput = new BufferedInputStream(input, dsize);
	try {
	    newdata.streamIn (binput);
	}catch (IOException e) {
	    System.out.println (e);
	    System.exit (-1);
	}
	
	// newdata.asciiDump ();
	
	// test equality between newdata and data
	if (olddata.equals (newdata) )
	    System.out.print ("Old Data == newdata\n");
	else
	    System.out.print ("Old Data != newdata\n");	    

	

	// test whether we can read from a file generated by C code
	// create a buffered input stream

	cdevData cdata = new cdevData ();
	try {
	    input = new FileInputStream (coutputfile);
	}catch (IOException e) {
	    System.out.println (e);
	    System.exit (-1);
	}
	binput = new BufferedInputStream(input, 8192);
	try {
	    cdata.streamIn (binput);
	}catch (IOException e) {
	    System.out.println (e);
	    System.exit (-1);
	}
	
	cdata.asciiDump ();  
	dsize = cdata.streamSize ();

	System.out.print ("C input Data size is " + String.valueOf(dsize) + "\n");
	
	// output some data stream let C++ to pick it up
	try {
	    output = new FileOutputStream (cinputfile);
	}catch (IOException e) {
	    System.out.println (e);
	    System.exit (-1);
	}
	boutput = new BufferedOutputStream(output, 2400);
	try {
	    cdata.streamOut (boutput);
	}catch (IOException e) {
	    System.out.println (e);
	    System.exit (-1);
	}
	
	try {
	    boutput.flush();
	}catch (IOException e) {
	    System.out.println (e);
	    System.exit (-1);
	}
    }
}


