//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG network server protocol header file
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogProtocol.h,v $
//   Revision 1.4  2001/07/25 14:26:37  chen
//   64 BIT Initial Port
//
//   Revision 1.3  2000/03/17 19:12:42  chen
//   add support for different version of protocols
//
//   Revision 1.2  2000/02/07 15:46:35  chen
//   add magic number
//
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:27  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_PROTOCOL_H
#define _CMLOG_PROTOCOL_H

#include <cmlog.h>
#include <cmlogConfig.h>

/* Protocol version number */
#define CMLOG_PROTOCOL_MAJOR_VERSION 2
#define CMLOG_PROTOCOL_MINOR_VERSION 0

/* caller check version    */
#define CMLOG_PROTOCOL_VERSION (1000*CMLOG_PTOTOCOL_MAJOR_VERSION + CMLOG_PROTOCOL_MINOR_VERSION)
#if (CMLOG_PROTOCOL_MAJOR_VERSION >= 2)
#define CMLOG_PROTOCOL_VERSION_STRING "cmlog protocol version 2.x"
#else
#define CMLOG_PROTOCOL_VERSION_STRING "cmlog protocol version 1.x"
#endif

/* The following commands are for cmlog server only                          */
#define CMLOG_UNKNOWN     ((unsigned)0)         /* unknown/init operation    */
#define CMLOG_EMPTY       ((unsigned)1)         /* empty message/ junk       */

#define CMLOG_MAGIC       ((unsigned char)0xa2) /* 10100010                  */
#define CMLOG_PMAGIC      ((unsigned)0xcde50052)/* packet magic number       */
#define CMLOG_CLNTLKSVC   ((unsigned)3000)      /* client looking for server */
#define CMLOG_BRSERLKSVC  ((unsigned)3001)      /* Browser looking for server*/
#define CMLOG_ADMINLKSVC  ((unsigned)3002)      /* admin looking for server  */
#define CMLOG_SERVERALIVE ((unsigned)3003)      /* Server is alive and well  */
#define CMLOG_USERLKCLNT  ((unsigned)3004)      /* user task look clnt daemon*/
#define CMLOG_TAGMAP      ((unsigned)3005)      /* Clnt sends tag map table  */
#define CMLOG_CONN_INFO   ((unsigned)3006)      /* logging connection info   */
#define CMLOG_CLOSE_CONN  ((unsigned)3007)      /* logging process quit      */
#define CMLOG_CHANGE_SRP  ((unsigned)3008)      /* change srv port to clnd   */

#define CMLOG_ADD_DATA    ((unsigned)3100)      /* add new data to database  */
#define CMLOG_FIND_DATA   ((unsigned)3101)      /* find data in the database */
#define CMLOG_ADD_CXT     ((unsigned)3102)      /* insert client context     */
#define CMLOG_CHANGE_TAGS ((unsigned)3103)      /* change tag map            */
#define CMLOG_FLUSH       ((unsigned)3104)      /* flush network buffer      */
#define CMLOG_ISR_DATA    ((unsigned)3105)      /* ISR from vx needs process */
#define CMLOG_GET_OPENFD  ((unsigned)3106)      /* get opend fd from a proc  */
#define CMLOG_GET_ATTR    ((unsigned)3107)      /* get server attributes     */
#define CMLOG_RECONN_INFO ((unsigned)3108)      /* reconnection info         */

#define CMLOG_EXIT        ((unsigned)4000)      /* internal  use only        */
#define CMLOG_DBASE       ((unsigned)4001)      /* internal  use only        */

/* magic number to find out whether the following message is  junk           */
#define CMLOG_EMPTY_SIZE  ((int)0x00deadbf)
/* magic number for data from ISR routine                                    */
#define CMLOG_ISR_FLAG   0x15e0beaf


#endif

