//-----------------------------------------------------------------------------
// Copyright (c) 1996 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//-----------------------------------------------------------------------------
//
// Description:
//       Common Message Logger Filter
//
// Author:  
//        Danjin Wu & Jie Chen
//       
//
// Revision History:
//   $Log: cmlogFilter.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:26:39  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_FILTER_H
#define _CMLOG_FILTER_H

#ifndef __vxworks
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/time.h>
#else
#include "vxWorks.h"
#include "stdio.h"
#include "string.h"
#include "math.h"
#endif

#include <cmlogProtocol.h>
#include <cmlogSlist.h>
#include <cdevData.h>

class cmlogFilter;

class cmlogCounter 
{
public:
  // constructor and destructor
  cmlogCounter  (void);
  ~cmlogCounter (void);
  
  void reset        (void);
  void init         (void); 

  void set          (BYTE val); 
  void set          (short val);
  void set          (unsigned short val); 
  void set          (long val); 
  void set          (unsigned long val); 
  void set          (float val); 
  void set          (double val); 
  void set          (char* val); 
    
  int match (BYTE val) const; 
  int match (short val) const;
  int match (unsigned short val) const;
  int match (long val) const;
  int match (unsigned long val) const;
  int match (float val) const;  
  int match (double val) const;
  int match (char*  val) const; 
  
  int update (int &dropFlag, int &num);
  double lastUpdate (void) const;
  void setLimit(int limit, double delta);

private:
  // data area
  int           valid_;
  cdevDataTypes type_;
  union dataUnion {
    BYTE             cval;
    short            sval;
    unsigned short   usval;
    long             lval;
    unsigned long    ulval;
    float            fval;
    double           dval;
    char            *str;
  } data_;
  int           count_;
  double        t0_;
  double        ts_;
  int           maxCount_;
  double        deltaTime_;

  friend class cmlogFilter;

  // deny access to assignment and copy operations
  cmlogCounter (const cmlogCounter& counter);
  cmlogCounter& operator = (const cmlogCounter& );
};

class cmlogFilter {  
public:
  // constructor and destructor
  cmlogFilter  (int maxSeverity, int maxVerbosity, int maxListSize);
  ~cmlogFilter (void);

  // operations
  int setVerbosityThreshold (int thresh);
  int getVerbosityThreshold (void) const;

  int setSeverityThreshold (int thresh);
  int getSeverityThreshold (void) const;

  int setThrottle (char *ctag, int listSize, int limit, double deltaTime);
  int getThrottle (char **ctag, int& listSize, int& limit, double& deltaTime);

  int filter      (cdevData& data);

protected:
  void setCounter(cdevDataTypes type, void *pdata, cmlogCounter *counterObj);
  int matchCounter(cdevDataTypes type, void *pdata, cmlogCounter *counterObj);

private:
  // data area
  
  // list of messages
  cmlogSlist msgList_;

  int        verbosityThreshold_;
  int        severityThreshold_;
  char*      throttleTag_;
  int        tag_;
  int        listSize_;
  int        limit_;
  double     delta_;

  int        maxSeverity_;
  int        maxVerbosity_;
  int        maxListSize_; 

  // default non useful tag
  static     int tag_no_use;

  // deny access to copy and assignment
  cmlogFilter (const cmlogFilter& );
  cmlogFilter& operator = (const cmlogFilter &);
};
#endif


