//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogDatabase Class (inline functions)
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: cmlogDatabase.i,v $
//   Revision 1.3  2000/03/01 18:35:19  chen
//   remove printf
//
//   Revision 1.2  2000/03/01 16:56:47  chen
//   Cocurrent control + db patches
//
//   Revision 1.1.1.1  1999/09/07 15:29:15  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:34:38  bickley
// Added cmlog to application development system.
//
//
//
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)

// we will change mutex to read write lock. 
cmlogDatabaseLocker::cmlogDatabaseLocker (cmlogDatabase* dbase)
:dbase_ (dbase)
{
  dbase_->mutex_.acquire ();
}

cmlogDatabaseLocker::~cmlogDatabaseLocker (void)
{
  dbase_->mutex_.release ();  
}

cmlogDatabaseWLocker::cmlogDatabaseWLocker (cmlogDatabase* dbase)
:dbase_ (dbase)
{
  dbase_->mutex_.acquire ();
}

cmlogDatabaseWLocker::~cmlogDatabaseWLocker (void)
{
  dbase_->mutex_.release ();  
}
#else
cmlogDatabaseLocker::cmlogDatabaseLocker (cmlogDatabase* dbase)
:dbase_ (dbase)
{
  DB* dbptr = dbase_->dbp_;
  int fd = -1;

  if (dbptr)
    fd = (*dbptr->fd)(dbptr);

  // posix lock structure
  struct flock lock;
  lock.l_type = F_RDLCK;
  lock.l_whence = SEEK_SET;
  lock.l_start = 0;
  lock.l_len = 0;
  
  if (fd != -1) {
    if (fcntl (fd, F_SETLKW, &lock) != 0) {
      fprintf (stderr, "Cannot do readlock on file <%s> with errno %d\n",
	       dbase->database(), errno);
    }
  }
}

cmlogDatabaseLocker::~cmlogDatabaseLocker (void)
{
  DB* dbptr = dbase_->dbp_;
  int fd = -1;

  if (dbptr)
    fd = (*dbptr->fd)(dbptr);

  // posix lock structure
  struct flock lock;
  lock.l_type = F_UNLCK;
  lock.l_whence = SEEK_SET;
  lock.l_start = 0;
  lock.l_len = 0;
  
  if (fd != -1) {
    if (fcntl (fd, F_SETLK, &lock) != 0) {
      fprintf (stderr, "%d: Cannot unlock a readlock on file <%s> with errno %d\n",
	       getpid(), dbase_->database(), errno);
    }
  }
}


cmlogDatabaseWLocker::cmlogDatabaseWLocker (cmlogDatabase* dbase)
:dbase_ (dbase)
{
  if (dbase_->flag_ == O_RDONLY)
    return;

  DB* dbptr = dbase_->dbp_;
  int fd = -1;
  if (dbptr)
    fd = (*dbptr->fd)(dbptr);

  // posix lock structure
  struct flock lock;
  lock.l_type = F_WRLCK;
  lock.l_whence = SEEK_SET;
  lock.l_start = 0;
  lock.l_len = 0;
  
  if (fd != -1) {
    if (fcntl (fd, F_SETLKW, &lock) != 0) {
      fprintf (stderr, "%d: Cannot do writelock on file <%s> with errno %d\n",
	       getpid(), dbase_->database(), errno);
    }
  }
}

cmlogDatabaseWLocker::~cmlogDatabaseWLocker (void)
{
  if (dbase_->flag_ == O_RDONLY)
    return;

  DB* dbptr = dbase_->dbp_;
  int fd = -1;

  if (dbptr)
    fd = (*dbptr->fd)(dbptr);

  // posix lock structure
  struct flock lock;
  lock.l_type = F_UNLCK;
  lock.l_whence = SEEK_SET;
  lock.l_start = 0;
  lock.l_len = 0;
  
  if (fd != -1) {
    if (fcntl (fd, F_SETLK, &lock) != 0) {
      fprintf (stderr, "%d: Cannot unlock a writelock on file <%s> with errno %d\n",
	       getpid (), dbase_->database(), errno);
    }
  }
}
#endif
